package com.atlassian.crowd.directory.loader;

import com.atlassian.crowd.directory.AzureAdDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.util.InstanceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Loads an implementation of a {@link AzureAdDirectory} for use at runtime by the Crowd security server.
 */
public class AzureAdDirectoryInstanceLoaderImpl extends AbstractDirectoryInstanceLoader implements AzureAdDirectoryInstanceLoader {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private final InstanceFactory instanceFactory;

    public AzureAdDirectoryInstanceLoaderImpl(final InstanceFactory instanceFactory) {
        this.instanceFactory = checkNotNull(instanceFactory);
    }

    public RemoteDirectory getRawDirectory(Long id, String className, Map<String, String> attributes) throws DirectoryInstantiationException {
        return RemoteDirectoryInstanceFactoryUtil.newRemoteDirectory(instanceFactory, id, className, attributes);
    }

    public boolean canLoad(final String className) {
        try {
            return AzureAdDirectory.class.isAssignableFrom(Class.forName(className));
        } catch (ClassNotFoundException e) {
            logger.error("Could not load class <" + className + ">", e);
            return false;
        }
    }
}
