package com.atlassian.crowd.directory.authentication.impl;

import com.atlassian.crowd.directory.authentication.UserCredentialVerifierFactory;
import com.atlassian.crowd.directory.rest.endpoint.AzureApiUriResolver;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.microsoft.aad.msal4j.PublicClientApplication;

import java.net.MalformedURLException;

public class MsalUserCredentialVerifierFactory implements UserCredentialVerifierFactory {
    @Override
    public MsalUserCredentialVerifier create(final AzureApiUriResolver endpointDataProvider, final String nativeClientId,
                                             final String tenantId) {
        try {
            PublicClientApplication app = PublicClientApplication.builder(nativeClientId)
                    .authority(endpointDataProvider.getAuthorityApiUrl(tenantId))
                    .build();
            return new MsalUserCredentialVerifier(app, endpointDataProvider);
        } catch (MalformedURLException e) {
            throw new OperationFailedException(e);
        }
    }
}
