package com.atlassian.crowd.directory.authentication.impl;

import com.atlassian.crowd.directory.authentication.UserCredentialVerifier;
import com.atlassian.crowd.directory.rest.endpoint.AzureApiUriResolver;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.MsalInteractionRequiredException;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.UserNamePasswordParameters;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class MsalUserCredentialVerifier implements UserCredentialVerifier {

    private final PublicClientApplication publicClientApplication;
    private final AzureApiUriResolver endpointDataProvider;

    public MsalUserCredentialVerifier(PublicClientApplication publicClientApplication, AzureApiUriResolver endpointDataProvider) {
        this.publicClientApplication = publicClientApplication;
        this.endpointDataProvider = endpointDataProvider;
    }

    @Override
    public void checkUserCredential(final String username, final PasswordCredential userCredential)
            throws InvalidAuthenticationException, OperationFailedException {
        try {
            UserNamePasswordParameters parameters = UserNamePasswordParameters
                    .builder(Collections.singleton(endpointDataProvider.getScopeUrl()), username, userCredential.getCredential().toCharArray())
                    .build();
            CompletableFuture<IAuthenticationResult> future = publicClientApplication.acquireToken(parameters);
            future.get();
        } catch (InterruptedException e) {
            throw new OperationFailedException(e);
        } catch (ExecutionException e) {
            if (e.getCause() instanceof MsalInteractionRequiredException) {
                throw new InvalidAuthenticationException("Could not authenticate user " + username, e);
            } else {
                throw new OperationFailedException(e);
            }
        }
    }
}
