package com.atlassian.crowd.directory.authentication.impl;

import com.atlassian.crowd.directory.authentication.MsGraphApiAuthenticator;
import com.atlassian.crowd.directory.authentication.MsGraphApiAuthenticatorFactory;
import com.atlassian.crowd.directory.rest.endpoint.AzureApiUriResolver;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IConfidentialClientApplication;

import java.net.MalformedURLException;

public class MsalAuthenticatorFactory implements MsGraphApiAuthenticatorFactory {
    @Override
    public MsGraphApiAuthenticator create(String clientId, String clientSecret, String tenantId, AzureApiUriResolver apiUriResolver) {
        try {
            ConfidentialClientApplication.Builder builder = ConfidentialClientApplication
                    .builder(clientId, ClientCredentialFactory.createFromSecret(clientSecret))
                    .authority(apiUriResolver.getAuthorityApiUrl(tenantId));

            IConfidentialClientApplication confidentialClientApplication = builder.build();
            return new MsalAuthenticator(confidentialClientApplication, apiUriResolver);
        } catch (MalformedURLException e) {
            throw new OperationFailedException(e);
        }
    }
}
