package com.atlassian.crowd.directory.authentication;

import com.atlassian.crowd.directory.rest.endpoint.AzureApiUriResolver;

/**
 * Creates an {@link UserCredentialVerifier}
 */
public interface UserCredentialVerifierFactory {

    /**
     * Creates a new UserCredentialVerifier instance
     * @param endpointDataProvider Endpoint data provider appropriate for given azure ad application's region
     * @param nativeClientId microsoft azure ad application's native id
     * @param tenantId microsoft azure ad tenant's id
     * @return a constructed UserCredentialVerifier
     */
    UserCredentialVerifier create(AzureApiUriResolver endpointDataProvider, String nativeClientId, String tenantId);
}
