package com.atlassian.crowd.directory.authentication;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;

/**
 * Responsible for verifying users credentials
 * @since 3.0
 */
public interface UserCredentialVerifier {

    /**
     * Checks whether the user with the provided username can authenticate against Azure AD with provided credential.
     * @param username username to authenticate the user
     * @param userCredential credential to authenticate the user
     * @throws InvalidAuthenticationException if the authentication details provided are not valid, or if the user does not exist
     * @throws OperationFailedException if the underlying implementation failed to execute the operation
     */
    void checkUserCredential(String username, PasswordCredential userCredential)
            throws InvalidAuthenticationException, OperationFailedException;
}
