package com.atlassian.crowd.directory.authentication;

import com.atlassian.crowd.directory.rest.endpoint.AzureApiUriResolver;

/**
 * Creates an {@link MsGraphApiAuthenticator}
 */
public interface MsGraphApiAuthenticatorFactory {
    /**
     * Creates a new MsGraphApiAuthenticator instance
     * @param clientId microsoft azure ad application's (web app) id
     * @param clientSecret microsoft azure ad application's (web app) client key
     * @param tenantId microsoft azure ad tenant's id
     * @param apiUriResolver Endpoint data provider appropriate for given azure ad application's region
     * @return a constructed MsGraphApiAuthenticator
     */
    MsGraphApiAuthenticator create(
            final String clientId,
            final String clientSecret,
            final String tenantId,
            final AzureApiUriResolver apiUriResolver);
}
