package com.atlassian.crowd.directory.authentication;

import com.atlassian.crowd.exception.OperationFailedException;
import com.microsoft.aad.msal4j.IAuthenticationResult;

/**
 * Handles authenticating to Microsoft Graph using the MSAL library
 */
public interface MsGraphApiAuthenticator {

    /**
     * Authenticates to Microsoft Graph
     * @return result containing the access token and expiry information
     * @throws OperationFailedException in case of unexpected failure
     */
    IAuthenticationResult getApiToken() throws OperationFailedException;
}
