package com.atlassian.crowd.directory.authentication;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;

/**
 * Jersey ClientFilter for Azure AD authentication support. Will generate a new authentication token if not present,
 * add the token to the request and retry the request if the token has expired.
 */
public class AzureAdRefreshTokenFilter extends ClientFilter {

    private final AzureAdTokenRefresher azureAdTokenRefresher;

    public AzureAdRefreshTokenFilter(final AzureAdTokenRefresher azureAdTokenRefresher) {
        this.azureAdTokenRefresher = azureAdTokenRefresher;
    }

    @Override
    public ClientResponse handle(final ClientRequest cr) throws ClientHandlerException {
        return azureAdTokenRefresher.handle(cr, this::getNext);
    }
}
