/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.AttributeValuesHolder;
import com.atlassian.crowd.directory.AzureMembershipHelper;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.authentication.UserCredentialVerifier;
import com.atlassian.crowd.directory.authentication.UserCredentialVerifierFactory;
import com.atlassian.crowd.directory.cache.AzureGroupFilterProcessor;
import com.atlassian.crowd.directory.query.FetchMode;
import com.atlassian.crowd.directory.query.GraphQuery;
import com.atlassian.crowd.directory.query.MicrosoftGraphDeltaToken;
import com.atlassian.crowd.directory.query.MicrosoftGraphQueryTranslator;
import com.atlassian.crowd.directory.query.ODataExpand;
import com.atlassian.crowd.directory.query.ODataFilter;
import com.atlassian.crowd.directory.query.ODataSelect;
import com.atlassian.crowd.directory.query.ODataTop;
import com.atlassian.crowd.directory.rest.AzureAdPagingWrapper;
import com.atlassian.crowd.directory.rest.AzureAdRestClient;
import com.atlassian.crowd.directory.rest.AzureAdRestClientFactory;
import com.atlassian.crowd.directory.rest.delta.GraphDeltaQueryResult;
import com.atlassian.crowd.directory.rest.endpoint.AzureApiUriResolver;
import com.atlassian.crowd.directory.rest.endpoint.AzureApiUriResolverFactory;
import com.atlassian.crowd.directory.rest.entity.PageableGraphList;
import com.atlassian.crowd.directory.rest.entity.delta.GraphDeltaQueryGroup;
import com.atlassian.crowd.directory.rest.entity.delta.GraphDeltaQueryUser;
import com.atlassian.crowd.directory.rest.entity.group.GraphGroup;
import com.atlassian.crowd.directory.rest.entity.group.GraphGroupList;
import com.atlassian.crowd.directory.rest.entity.membership.DirectoryObject;
import com.atlassian.crowd.directory.rest.entity.user.GraphUser;
import com.atlassian.crowd.directory.rest.entity.user.GraphUsersList;
import com.atlassian.crowd.directory.rest.mapper.AzureAdRestEntityMapper;
import com.atlassian.crowd.directory.rest.mapper.DeltaQueryResult;
import com.atlassian.crowd.directory.rest.util.MembershipFilterUtil;
import com.atlassian.crowd.directory.synchronisation.Defaults;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotSupportedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.avatar.AvatarReference;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupTemplateWithAttributes;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.group.GroupWithMembershipChanges;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.QueryUtils;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.search.util.QuerySplitter;
import com.atlassian.crowd.search.util.SearchResultsUtil;
import com.atlassian.crowd.util.AttributeUtil;
import com.atlassian.crowd.util.BoundedCount;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureAdDirectory
implements RemoteDirectory {
    private static Logger logger = LoggerFactory.getLogger(AzureAdDirectory.class);
    public static final String WEBAPP_CLIENT_ID_ATTRIBUTE = "AZURE_AD_WEBAPP_CLIENT_ID";
    public static final String WEBAPP_CLIENT_SECRET_ATTRIBUTE = "AZURE_AD_WEBAPP_CLIENT_SECRET";
    public static final String TENANT_ID_ATTRIBUTE = "AZURE_AD_TENANT_ID";
    public static final String NATIVE_APP_ID_ATTRIBUTE = "AZURE_AD_NATIVE_AP_IDD";
    public static final String GRAPH_API_ENDPOINT_ATTRIBUTE = "AZURE_AD_GRAPH_API_ENDPOINT";
    public static final String AUTHORITY_API_ENDPOINT_ATTRIBUTE = "AZURE_AD_AUTHORITY_API_ENDPOINT";
    public static final String REGION_ATTRIBUTE = "AZURE_AD_REGION";
    public static final String CUSTOM_REGION_ATTRIBUTE_VALUE = "CUSTOM";
    public static final String FILTERED_GROUPS_ATTRIBUTE = "AZURE_AD_FILTERED_GROUPS";
    public static final String GROUP_FILTERING_ENABLED_ATTRIBUTE = "GROUP_FILTERING_ENABLED";
    public static final String NOT_IMPLEMENTED = "Azure Active Directory support is Read-only";
    public static final int MAX_RESTRICTIONS_PER_QUERY = 10;
    private final AzureAdRestClientFactory restClientFactory;
    private final MicrosoftGraphQueryTranslator graphQueryTranslator;
    private final AzureAdRestEntityMapper restEntityMapper;
    private final UserCredentialVerifierFactory credentialVerifierFactory;
    private final AzureApiUriResolverFactory endpointDataProviderFactory;
    private AzureApiUriResolver endpointDataProvider;
    private Supplier<UserCredentialVerifier> userCredentialVerifier;
    private Supplier<AzureAdRestClient> azureAdRestClient;
    private Supplier<AzureAdPagingWrapper> azureAdPagingWrapper;
    private AttributeValuesHolder attributes;
    private long directoryId;
    private boolean supportsNestedGroups;

    public AzureAdDirectory(AzureAdRestClientFactory restClientFactory, MicrosoftGraphQueryTranslator graphQueryTranslator, AzureAdRestEntityMapper restEntityMapper, UserCredentialVerifierFactory credentialVerifierFactory, AzureApiUriResolverFactory endpointDataProviderFactory) {
        this.restClientFactory = restClientFactory;
        this.graphQueryTranslator = graphQueryTranslator;
        this.restEntityMapper = restEntityMapper;
        this.credentialVerifierFactory = credentialVerifierFactory;
        this.endpointDataProviderFactory = endpointDataProviderFactory;
    }

    @Nullable
    public Set<String> getValues(String key) {
        return this.attributes.getValues(key);
    }

    @Nullable
    public String getValue(String key) {
        return this.attributes.getValue(key);
    }

    public Set<String> getKeys() {
        return this.attributes.getKeys();
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(long directoryId) {
        this.directoryId = directoryId;
    }

    @Nonnull
    public String getDescriptiveName() {
        return "Microsoft Azure Active Directory";
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = new AttributeValuesHolder(attributes);
        String webappClientId = attributes.get(WEBAPP_CLIENT_ID_ATTRIBUTE);
        String webappClientSecret = attributes.get(WEBAPP_CLIENT_SECRET_ATTRIBUTE);
        String tenantId = attributes.get(TENANT_ID_ATTRIBUTE);
        String nativeClientId = attributes.get(NATIVE_APP_ID_ATTRIBUTE);
        Duration connectionTimeout = AttributeUtil.safeParseDurationMillis((String)attributes.get("ldap.connection.timeout"), (Duration)Defaults.CONNECTION_TIMEOUT);
        Duration readTimeout = AttributeUtil.safeParseDurationMillis((String)attributes.get("ldap.read.timeout"), (Duration)Defaults.READ_TIMEOUT);
        this.endpointDataProvider = this.endpointDataProviderFactory.getEndpointDataProviderForDirectory(this);
        this.supportsNestedGroups = Boolean.parseBoolean(attributes.get("useNestedGroups"));
        this.azureAdRestClient = () -> ((com.google.common.base.Supplier)Suppliers.memoize(() -> this.restClientFactory.create(webappClientId, webappClientSecret, tenantId, this.endpointDataProvider, connectionTimeout.toMillis(), readTimeout.toMillis()))).get();
        this.azureAdPagingWrapper = () -> ((com.google.common.base.Supplier)Suppliers.memoize(() -> this.restClientFactory.create(this.getRestClient()))).get();
        this.userCredentialVerifier = () -> ((com.google.common.base.Supplier)Suppliers.memoize(() -> this.credentialVerifierFactory.create(this.endpointDataProvider, nativeClientId, tenantId))).get();
    }

    @Nonnull
    public User findUserByName(String name) throws UserNotFoundException, OperationFailedException {
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)name)).returningAtMost(1);
        GraphQuery graphQuery = this.graphQueryTranslator.convert(query);
        GraphUsersList graphUsersList = this.getRestClient().searchUsers(graphQuery);
        this.validateSingleResult(graphUsersList, () -> new UserNotFoundException(name));
        return (User)Iterables.getOnlyElement(this.restEntityMapper.mapUsers(graphUsersList, query.getReturnType(), this.directoryId));
    }

    @Nonnull
    public UserWithAttributes findUserWithAttributesByName(String name) throws UserNotFoundException, OperationFailedException {
        return UserTemplateWithAttributes.toUserWithNoAttributes((User)this.findUserByName(name));
    }

    @Nonnull
    public User findUserByExternalId(String externalId) throws UserNotFoundException, OperationFailedException {
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.EXTERNAL_ID).exactlyMatching((Object)externalId)).returningAtMost(1);
        GraphQuery graphQuery = this.graphQueryTranslator.convert(query);
        GraphUsersList graphUsersList = this.getRestClient().searchUsers(graphQuery);
        this.validateSingleResult(graphUsersList, () -> UserNotFoundException.forExternalId((String)externalId));
        return (User)Iterables.getOnlyElement(this.restEntityMapper.mapUsers(graphUsersList, User.class, this.directoryId));
    }

    @Nonnull
    public User authenticate(String name, PasswordCredential credential) throws UserNotFoundException, InactiveAccountException, InvalidAuthenticationException, ExpiredCredentialException, OperationFailedException {
        User user = this.findUserByName(name);
        this.getUserCredentialVerifier().checkUserCredential(name, credential);
        return user;
    }

    @Nonnull
    public User addUser(UserTemplate user, PasswordCredential credential) throws InvalidUserException, InvalidCredentialException, UserAlreadyExistsException, OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    public UserWithAttributes addUser(UserTemplateWithAttributes user, PasswordCredential credential) throws InvalidUserException, InvalidCredentialException, UserAlreadyExistsException, OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    @Nonnull
    public User updateUser(UserTemplate user) throws InvalidUserException, UserNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    public void updateUserCredential(String username, PasswordCredential credential) throws UserNotFoundException, InvalidCredentialException, OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    @Nonnull
    public User renameUser(String oldName, String newName) throws UserNotFoundException, InvalidUserException, UserAlreadyExistsException, OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    public void storeUserAttributes(String username, Map<String, Set<String>> attributes) throws UserNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    public void removeUserAttributes(String username, String attributeName) throws UserNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    public void removeUser(String name) throws UserNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    @Nonnull
    public <T> List<T> searchUsers(EntityQuery<T> query) throws OperationFailedException {
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, User.class});
        return QuerySplitter.batchConditionsIfNeeded(query, this::searchUsersSplit, (int)10);
    }

    private <T> List<T> searchUsersSplit(EntityQuery<T> query) throws OperationFailedException {
        GraphQuery graphQuery = this.graphQueryTranslator.convert(query);
        List<GraphUser> results = this.getAzureAdPagingWrapper().fetchAppropriateAmountOfResults(this.getRestClient().searchUsers(graphQuery), query.getStartIndex(), query.getMaxResults());
        return this.restEntityMapper.mapUsers(results, query.getReturnType(), this.getDirectoryId());
    }

    @Nonnull
    public Group findGroupByName(String name) throws GroupNotFoundException, OperationFailedException {
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).exactlyMatching((Object)name)).returningAtMost(1);
        GraphQuery graphQuery = this.graphQueryTranslator.convert(query);
        GraphGroupList graphGroupList = this.getRestClient().searchGroups(graphQuery);
        this.validateSingleResult(graphGroupList, () -> new GroupNotFoundException(name));
        return (Group)Iterables.getOnlyElement(this.restEntityMapper.mapGroups(graphGroupList, query.getReturnType(), this.directoryId));
    }

    @Nonnull
    public GroupWithAttributes findGroupWithAttributesByName(String name) throws GroupNotFoundException, OperationFailedException {
        return GroupTemplateWithAttributes.ofGroupWithNoAttributes((Group)this.findGroupByName(name));
    }

    @Nonnull
    public Group addGroup(GroupTemplate group) throws InvalidGroupException, OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    @Nonnull
    public Group updateGroup(GroupTemplate group) throws InvalidGroupException, GroupNotFoundException, ReadOnlyGroupException, OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    @Nonnull
    public Group renameGroup(String oldName, String newName) throws GroupNotFoundException, InvalidGroupException, OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    public void storeGroupAttributes(String groupName, Map<String, Set<String>> attributes) throws GroupNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    public void removeGroupAttributes(String groupName, String attributeName) throws GroupNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    public void removeGroup(String name) throws GroupNotFoundException, ReadOnlyGroupException, OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    @Nonnull
    public <T> List<T> searchGroups(EntityQuery<T> query) throws OperationFailedException {
        QueryUtils.checkAssignableFrom((Class)query.getReturnType(), (Class[])new Class[]{String.class, Group.class});
        return QuerySplitter.batchConditionsIfNeeded(query, this::searchGroupsSplit, (int)10);
    }

    private <T> List<T> searchGroupsSplit(EntityQuery<T> query) throws OperationFailedException {
        GraphQuery graphQuery = this.graphQueryTranslator.convert(query);
        GraphGroupList graphGroupsList = this.getRestClient().searchGroups(graphQuery);
        List<GraphGroup> results = this.getAzureAdPagingWrapper().fetchAppropriateAmountOfResults(graphGroupsList, query.getStartIndex(), query.getMaxResults());
        return this.restEntityMapper.mapGroups(results, query.getReturnType(), this.getDirectoryId());
    }

    public boolean isUserDirectGroupMember(String username, String groupName) throws OperationFailedException {
        ODataSelect select = this.graphQueryTranslator.resolveAzureAdColumnsForSingleEntityTypeQuery(EntityDescriptor.group(), FetchMode.NAME);
        Optional<DirectoryObject> maybeGroup = this.getAzureAdPagingWrapper().pageForElement(this.getRestClient().getDirectParentsOfUser(username, select), this.withGroup(groupName));
        return maybeGroup.isPresent();
    }

    private Predicate<DirectoryObject> withGroup(String groupName) {
        return g -> MembershipFilterUtil.isGroup(g) && g.getDisplayName().equals(groupName);
    }

    public boolean isGroupDirectGroupMember(String childGroup, String parentGroup) throws OperationFailedException {
        String groupExternalId = this.fetchExternalIdOfGroup(childGroup).orElseThrow(() -> new OperationFailedException((Throwable)new GroupNotFoundException(childGroup)));
        ODataSelect select = this.graphQueryTranslator.resolveAzureAdColumnsForSingleEntityTypeQuery(EntityDescriptor.group(), FetchMode.NAME);
        Optional<DirectoryObject> maybeGroup = this.getAzureAdPagingWrapper().pageForElement(this.getRestClient().getDirectParentsOfGroup(groupExternalId, select), this.withGroup(parentGroup));
        return maybeGroup.isPresent();
    }

    @Nonnull
    public BoundedCount countDirectMembersOfGroup(String groupName, int querySizeHint) throws OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    public void addUserToGroup(String username, String groupName) throws GroupNotFoundException, UserNotFoundException, ReadOnlyGroupException, OperationFailedException, MembershipAlreadyExistsException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    public void addGroupToGroup(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, ReadOnlyGroupException, OperationFailedException, MembershipAlreadyExistsException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    public void removeUserFromGroup(String username, String groupName) throws GroupNotFoundException, UserNotFoundException, MembershipNotFoundException, ReadOnlyGroupException, OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    public void removeGroupFromGroup(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, MembershipNotFoundException, ReadOnlyGroupException, OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    @Nonnull
    public <T> List<T> searchGroupRelationships(MembershipQuery<T> query) throws OperationFailedException {
        Preconditions.checkArgument((query.getSearchRestriction() == NullRestrictionImpl.INSTANCE ? 1 : 0) != 0, (Object)"Azure AD membership queries do not support search restrictions.");
        if (query.getEntityToReturn() == EntityDescriptor.group() && query.getEntityToMatch() == EntityDescriptor.group() && !this.supportsNestedGroups) {
            return Collections.emptyList();
        }
        ODataSelect select = this.graphQueryTranslator.resolveAzureAdColumnsForSingleEntityTypeQuery(query.getEntityToReturn(), query.getReturnType());
        ArrayList<T> results = new ArrayList<T>();
        if (query.isFindChildren()) {
            Preconditions.checkArgument((query.getEntityToMatch() == EntityDescriptor.group() ? 1 : 0) != 0, (Object)"Cannot search for children of entities other than groups");
            Predicate<DirectoryObject> filter = this.getDirectoryObjectFilter(query);
            for (String groupId : this.getGroupIds(query.getEntityNamesToMatch())) {
                List<DirectoryObject> groupChildren = this.getAzureAdPagingWrapper().fetchAllMatchingResults(this.getRestClient().getDirectChildrenOfGroup(groupId, select), filter);
                results.addAll(this.restEntityMapper.mapDirectoryObjects(groupChildren, query.getReturnType(), this.directoryId));
            }
        } else {
            Preconditions.checkArgument((query.getEntityToReturn() == EntityDescriptor.group() ? 1 : 0) != 0, (Object)"Cannot search for parents of other types than groups");
            if (query.getEntityToMatch() == EntityDescriptor.user()) {
                for (String username : query.getEntityNamesToMatch()) {
                    List<DirectoryObject> groupParents = this.getAzureAdPagingWrapper().fetchAllResults(this.getRestClient().getDirectParentsOfUser(username, select));
                    results.addAll(this.mapGroupMemberships(query, groupParents));
                }
            } else if (query.getEntityToMatch() == EntityDescriptor.group()) {
                for (String groupId : this.getGroupIds(query.getEntityNamesToMatch())) {
                    List<DirectoryObject> groupParents = this.getAzureAdPagingWrapper().fetchAllResults(this.getRestClient().getDirectParentsOfGroup(groupId, select));
                    results.addAll(this.mapGroupMemberships(query, groupParents));
                }
            } else {
                throw new IllegalArgumentException("Unsupported entity type " + query.getEntityToMatch());
            }
        }
        return SearchResultsUtil.constrainResults(results, (int)query.getStartIndex(), (int)query.getMaxResults());
    }

    private List<String> getGroupIds(Collection<String> names) throws OperationFailedException {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : names) {
            this.fetchExternalIdOfGroup(name).ifPresent(result::add);
        }
        return result;
    }

    public void testConnection() throws OperationFailedException {
        GraphQuery graphQuery = this.graphQueryTranslator.convert(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(1));
        this.azureAdRestClient.get().searchUsers(graphQuery);
    }

    public boolean supportsInactiveAccounts() {
        return true;
    }

    public boolean supportsNestedGroups() {
        return this.supportsNestedGroups;
    }

    public boolean supportsPasswordExpiration() {
        return false;
    }

    public boolean supportsSettingEncryptedCredential() {
        return false;
    }

    public boolean isRolesDisabled() {
        return true;
    }

    @Nonnull
    public Iterable<Membership> getMemberships() throws OperationFailedException {
        Iterator<Membership> iterator = this.createMembershipHelper().membershipIterator();
        return () -> iterator;
    }

    @Nonnull
    public RemoteDirectory getAuthoritativeDirectory() {
        return this;
    }

    public void expireAllPasswords() throws OperationFailedException {
        throw new OperationNotSupportedException(NOT_IMPLEMENTED);
    }

    @Nullable
    public AvatarReference getUserAvatarByName(String username, int sizeHint) {
        return null;
    }

    public boolean isGroupFilteringEnabled() {
        return Boolean.parseBoolean(this.getValue(GROUP_FILTERING_ENABLED_ATTRIBUTE));
    }

    public Set<String> getGroupsNamesToFilter() {
        String groupsToFilterAttribute = this.getValue(FILTERED_GROUPS_ATTRIBUTE);
        return AzureGroupFilterProcessor.getGroupNames(groupsToFilterAttribute);
    }

    public List<GroupWithAttributes> getFilteredGroups() throws OperationFailedException {
        ImmutableList groupNamesToFilter = ImmutableList.copyOf(this.getGroupsNamesToFilter());
        ImmutableList groupsFromAzureAd = ImmutableList.copyOf(this.searchGroups(QueryBuilder.queryFor(GroupWithAttributes.class, (EntityDescriptor)EntityDescriptor.group()).with(Restriction.on((Property)GroupTermKeys.NAME).exactlyMatchingAny((Collection)groupNamesToFilter)).returningAtMost(-1)));
        this.logNotExistingGroupNames((ImmutableList<String>)groupNamesToFilter, (ImmutableList<GroupWithAttributes>)groupsFromAzureAd);
        return groupsFromAzureAd;
    }

    private void logNotExistingGroupNames(ImmutableList<String> groupNamesToFilter, ImmutableList<GroupWithAttributes> groupsFromAzureAd) {
        List groupNamesFromAzureAd = groupsFromAzureAd.stream().map(DirectoryEntity::getName).collect(Collectors.toList());
        Set groupsNotFoundInAzureAd = groupNamesToFilter.stream().filter(IdentifierUtils.containsIdentifierPredicate(groupNamesFromAzureAd).negate()).collect(Collectors.toSet());
        if (!groupsNotFoundInAzureAd.isEmpty()) {
            logger.warn("Non existent Group(s) to filter out in Azure AD: {}", groupsNotFoundInAzureAd);
        }
    }

    public DeltaQueryResult<UserWithAttributes> performUsersDeltaQuery() throws OperationFailedException {
        ODataSelect select = this.graphQueryTranslator.resolveAzureAdColumnsForSingleEntityTypeQuery(EntityDescriptor.user(), FetchMode.DELTA_QUERY);
        GraphDeltaQueryResult<GraphDeltaQueryUser> results = this.getAzureAdPagingWrapper().fetchAllDeltaQueryResults(this.getRestClient().performUsersDeltaQuery(select));
        return this.restEntityMapper.mapDeltaQueryUsers(results, this.getDirectoryId());
    }

    public DeltaQueryResult<GroupWithMembershipChanges> performGroupsDeltaQuery() throws OperationFailedException {
        ODataExpand expand = this.graphQueryTranslator.resolveAzureAdNavigationPropertiesForSingleEntityTypeQuery(EntityDescriptor.group(), FetchMode.DELTA_QUERY);
        ODataSelect select = this.graphQueryTranslator.resolveAzureAdColumnsForSingleEntityTypeQuery(EntityDescriptor.group(), FetchMode.DELTA_QUERY);
        GraphDeltaQueryResult<GraphDeltaQueryGroup> results = this.getAzureAdPagingWrapper().fetchAllDeltaQueryResults(this.getRestClient().performGroupsDeltaQuery(select, expand));
        return this.restEntityMapper.mapDeltaQueryGroups(results, this.getDirectoryId());
    }

    public DeltaQueryResult<GroupWithMembershipChanges> fetchGroupChanges(String syncToken) throws OperationFailedException {
        GraphDeltaQueryResult<GraphDeltaQueryGroup> groups = this.getAzureAdPagingWrapper().fetchAllDeltaQueryResults(this.getRestClient().performGroupsDeltaQuery(new MicrosoftGraphDeltaToken(syncToken)));
        return this.restEntityMapper.mapDeltaQueryGroups(groups, this.getDirectoryId());
    }

    public DeltaQueryResult<UserWithAttributes> fetchUserChanges(String syncToken) throws OperationFailedException {
        GraphDeltaQueryResult<GraphDeltaQueryUser> users = this.getAzureAdPagingWrapper().fetchAllDeltaQueryResults(this.getRestClient().performUsersDeltaQuery(new MicrosoftGraphDeltaToken(syncToken)));
        return this.restEntityMapper.mapDeltaQueryUsers(users, this.getDirectoryId());
    }

    private Optional<String> fetchExternalIdOfGroup(String groupName) throws OperationFailedException {
        ODataFilter filter = this.graphQueryTranslator.translateSearchRestriction(EntityDescriptor.group(), (SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).exactlyMatching((Object)groupName));
        ODataSelect select = this.graphQueryTranslator.resolveAzureAdColumnsForSingleEntityTypeQuery(EntityDescriptor.group(), FetchMode.ID);
        GraphGroupList groupList = this.getRestClient().searchGroups(new GraphQuery(filter, select, 0, ODataTop.SINGLE_RESULT));
        List groups = groupList.getEntries();
        if (groups.isEmpty()) {
            return Optional.empty();
        }
        if (groups.size() > 1) {
            throw new IllegalStateException(String.format("More than one group with name %s exists", groupName));
        }
        return Optional.of(((GraphGroup)Iterables.getOnlyElement(groups)).getId());
    }

    public boolean supportsDeltaQueryApi() {
        return this.getRestClient().supportsDeltaQuery();
    }

    private <T> Predicate<DirectoryObject> getDirectoryObjectFilter(MembershipQuery<T> query) {
        if (query.getEntityToReturn() == EntityDescriptor.user()) {
            return MembershipFilterUtil::isUser;
        }
        if (query.getEntityToReturn() == EntityDescriptor.group()) {
            return MembershipFilterUtil::isGroup;
        }
        throw new IllegalStateException("Unsupported entity type " + query.getEntityToReturn());
    }

    private <T> List<T> mapGroupMemberships(MembershipQuery<T> query, List<DirectoryObject> groupParents) {
        return this.restEntityMapper.mapDirectoryObjects(groupParents.stream().filter(MembershipFilterUtil::isGroup).collect(Collectors.toList()), query.getReturnType(), this.directoryId);
    }

    private <T extends Exception> void validateSingleResult(PageableGraphList results, Supplier<T> noResultsFoundExceptionSupplier) throws T {
        int amountOfResults = results.getEntries().size();
        if (amountOfResults == 0) {
            throw (Exception)noResultsFoundExceptionSupplier.get();
        }
        if (amountOfResults > 1) {
            throw new IllegalStateException(String.format("Expected one result, found %d. Please verify that there are noentities with duplicate names in the directory", amountOfResults));
        }
    }

    public AzureMembershipHelper createMembershipHelper() {
        return new AzureMembershipHelper(this.getRestClient(), this.getAzureAdPagingWrapper(), this.graphQueryTranslator, this.restEntityMapper, this);
    }

    @VisibleForTesting
    public AzureAdRestClient getRestClient() {
        return this.azureAdRestClient.get();
    }

    private UserCredentialVerifier getUserCredentialVerifier() {
        return this.userCredentialVerifier.get();
    }

    private AzureAdPagingWrapper getAzureAdPagingWrapper() {
        return this.azureAdPagingWrapper.get();
    }

    public MicrosoftGraphQueryTranslator getTranslator() {
        return this.graphQueryTranslator;
    }
}

