/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.rest.util;

import com.atlassian.crowd.directory.rest.entity.group.GraphGroup;
import com.atlassian.crowd.model.group.Group;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BinaryOperator;

public final class ThrowingMapMergeOperatorUtil {
    private ThrowingMapMergeOperatorUtil() {
    }

    public static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    public static BinaryOperator<String> duplicateAzureAdGroupsThrowingMerger(Collection<GraphGroup> groups) {
        return (u, v) -> {
            Optional<GraphGroup> matchingGroup = groups.stream().filter(group -> group.getId().equals(u) || group.getId().equals(v)).findAny();
            throw new IllegalStateException(String.format("Found groups with duplicate name '%s', ids: '%s', '%s'", matchingGroup.get().getDisplayName(), u, v));
        };
    }

    public static <T extends Group> BinaryOperator<String> duplicateMappedGroupsThrowingMerger(Collection<T> groups) {
        return (u, v) -> {
            Optional<Group> matchingGroup = groups.stream().filter(group -> group.getExternalId().equals(u) || group.getExternalId().equals(v)).findAny();
            throw new IllegalStateException(String.format("Found groups with duplicate name '%s', ids: '%s', '%s'", matchingGroup.get().getName(), u, v));
        };
    }
}

