/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.rest.mapper;

import com.atlassian.crowd.directory.rest.delta.GraphDeltaQueryResult;
import com.atlassian.crowd.directory.rest.entity.GraphDirectoryObjectList;
import com.atlassian.crowd.directory.rest.entity.delta.GraphDeltaQueryGroup;
import com.atlassian.crowd.directory.rest.entity.delta.GraphDeltaQueryMembership;
import com.atlassian.crowd.directory.rest.entity.delta.GraphDeltaQueryUser;
import com.atlassian.crowd.directory.rest.entity.group.GraphGroup;
import com.atlassian.crowd.directory.rest.entity.group.GraphGroupList;
import com.atlassian.crowd.directory.rest.entity.membership.DirectoryObject;
import com.atlassian.crowd.directory.rest.entity.membership.GraphMembershipGroup;
import com.atlassian.crowd.directory.rest.entity.membership.GraphMembershipUser;
import com.atlassian.crowd.directory.rest.entity.user.GraphUser;
import com.atlassian.crowd.directory.rest.entity.user.GraphUsersList;
import com.atlassian.crowd.directory.rest.mapper.DeltaQueryResult;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupTemplateWithAttributes;
import com.atlassian.crowd.model.group.GroupTemplateWithAttributesAndMembershipChanges;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriComponentsBuilder;

public class AzureAdRestEntityMapper {
    private static final Logger log = LoggerFactory.getLogger(AzureAdRestEntityMapper.class);

    public <T> List<T> mapUsers(GraphUsersList graphUsersList, Class<T> returnType, long directoryId) {
        return this.mapUsers(graphUsersList.getEntries(), returnType, directoryId);
    }

    public <T> List<T> mapUsers(Collection<GraphUser> graphUsersList, Class<T> returnType, long directoryId) {
        return graphUsersList.stream().map(graphUser -> this.mapUser((GraphUser)graphUser, returnType, directoryId)).collect(Collectors.toList());
    }

    public DeltaQueryResult<UserWithAttributes> mapDeltaQueryUsers(GraphDeltaQueryResult<GraphDeltaQueryUser> graphUsersList, long directoryId) {
        ImmutableList.Builder changedUsers = ImmutableList.builder();
        ImmutableSet.Builder removedUsers = ImmutableSet.builder();
        ImmutableSet.Builder namelessUsers = ImmutableSet.builder();
        graphUsersList.getResults().forEach(graphUser -> {
            if (graphUser.getRemoved() == null) {
                if (StringUtils.isNotBlank((CharSequence)graphUser.getUserPrincipalName())) {
                    changedUsers.add((Object)this.mapUser((GraphUser)graphUser, (Class)UserWithAttributes.class, directoryId));
                } else {
                    log.debug("Encountered a nameless user from Azure AD, name: {}, id: {}", (Object)graphUser.getUserPrincipalName(), (Object)graphUser.getId());
                    namelessUsers.add((Object)graphUser.getId());
                }
            } else {
                removedUsers.add((Object)graphUser.getId());
            }
        });
        List deltatoken = (List)UriComponentsBuilder.fromUriString((String)graphUsersList.getDeltaLink()).build().getQueryParams().get((Object)"$deltatoken");
        DeltaQueryResult<UserWithAttributes> result = new DeltaQueryResult<UserWithAttributes>((Collection<UserWithAttributes>)changedUsers.build(), (Set<String>)removedUsers.build(), (Set<String>)namelessUsers.build(), (String)Iterables.getOnlyElement((Iterable)deltatoken));
        this.logDeltaQueryResults("users", result);
        return result;
    }

    private <T> void logDeltaQueryResults(String entityType, DeltaQueryResult<T> result) {
        log.debug("Mapped delta query {} - Changed: {}, removed: {}, nameless: {}, delta token: {}", new Object[]{entityType, result.getChangedEntities(), result.getDeletedEntities(), result.getNamelessEntities(), result.getSyncToken()});
    }

    public <T> T mapUser(GraphUser graphUser, Class<T> returnType, long directoryId) {
        if (returnType == String.class) {
            return (T)graphUser.getUserPrincipalName();
        }
        UserTemplate userTemplate = new UserTemplate(graphUser.getUserPrincipalName(), graphUser.getGivenName(), graphUser.getSurname(), graphUser.getDisplayName());
        userTemplate.setDirectoryId(directoryId);
        userTemplate.setEmailAddress(graphUser.getMail());
        boolean mappedActive = graphUser.getAccountEnabled() != null ? graphUser.getAccountEnabled() : true;
        log.trace("Mapped active flag for user {} from {} to {}", new Object[]{graphUser.getUserPrincipalName(), graphUser.getAccountEnabled(), mappedActive});
        userTemplate.setActive(mappedActive);
        userTemplate.setExternalId(graphUser.getId());
        log.debug("Mapped Graph user to Crowd user {}", (Object)userTemplate);
        if (returnType == User.class) {
            return (T)userTemplate;
        }
        return (T)UserTemplateWithAttributes.toUserWithNoAttributes((User)userTemplate);
    }

    public <T> List<T> mapGroups(GraphGroupList graphGroupList, Class<T> returnType, long directoryId) {
        return this.mapGroups(graphGroupList.getEntries(), returnType, directoryId);
    }

    public <T> List<T> mapGroups(Collection<GraphGroup> graphGroups, Class<T> returnType, long directoryId) {
        return graphGroups.stream().map(graphGroup -> this.mapGroup((GraphGroup)graphGroup, returnType, directoryId)).collect(Collectors.toList());
    }

    public DeltaQueryResult<GroupTemplateWithAttributesAndMembershipChanges> mapDeltaQueryGroups(GraphDeltaQueryResult<GraphDeltaQueryGroup> graphGroups, long directoryId) {
        HashMap changedGroups = new HashMap();
        ImmutableSet.Builder removedGroups = ImmutableSet.builder();
        ImmutableSet.Builder namelessGroups = ImmutableSet.builder();
        graphGroups.getResults().forEach(graphGroup -> {
            if (graphGroup.getRemoved() == null) {
                if (StringUtils.isNotBlank((CharSequence)graphGroup.getDisplayName())) {
                    changedGroups.merge(graphGroup.getId(), this.mapDeltaQueryGroup((GraphDeltaQueryGroup)graphGroup, directoryId), (u, v) -> new GroupTemplateWithAttributesAndMembershipChanges((GroupWithAttributes)u, (Set<String>)ImmutableSet.builder().addAll(u.getUserChildrenIdsToAdd()).addAll(v.getUserChildrenIdsToAdd()).build(), (Set<String>)ImmutableSet.builder().addAll(u.getUserChildrenIdsToDelete()).addAll(v.getUserChildrenIdsToDelete()).build(), (Set<String>)ImmutableSet.builder().addAll(u.getGroupChildrenIdsToAdd()).addAll(v.getGroupChildrenIdsToAdd()).build(), (Set<String>)ImmutableSet.builder().addAll(u.getGroupChildrenIdsToDelete()).addAll(v.getGroupChildrenIdsToDelete()).build()));
                } else {
                    log.debug("Encountered a nameless group from Azure AD, name: {}, id: {}", (Object)graphGroup.getDisplayName(), (Object)graphGroup.getId());
                    namelessGroups.add((Object)graphGroup.getId());
                }
            } else {
                removedGroups.add((Object)graphGroup.getId());
            }
        });
        List deltatoken = (List)UriComponentsBuilder.fromUriString((String)graphGroups.getDeltaLink()).build().getQueryParams().get((Object)"$deltatoken");
        DeltaQueryResult<GroupTemplateWithAttributesAndMembershipChanges> result = new DeltaQueryResult<GroupTemplateWithAttributesAndMembershipChanges>(changedGroups.values(), (Set<String>)removedGroups.build(), (Set<String>)namelessGroups.build(), (String)Iterables.getOnlyElement((Iterable)deltatoken));
        this.logDeltaQueryResults("groups", result);
        return result;
    }

    public <T> List<T> mapDirectoryObjects(GraphDirectoryObjectList directoryObjectList, Class<T> returnType, long directoryId) {
        return this.mapDirectoryObjects(directoryObjectList.getEntries(), returnType, directoryId);
    }

    public <T> List<T> mapDirectoryObjects(Collection<DirectoryObject> directoryObjects, Class<T> returnType, long directoryId) {
        return directoryObjects.stream().map(graphGroup -> this.mapDirectoryObject((DirectoryObject)graphGroup, returnType, directoryId)).collect(Collectors.toList());
    }

    public <T> T mapGroup(GraphGroup graphGroup, Class<T> returnType, long directoryId) {
        if (returnType == String.class) {
            return (T)graphGroup.getDisplayName();
        }
        GroupTemplate groupTemplate = new GroupTemplate(graphGroup.getDisplayName(), directoryId);
        groupTemplate.setDescription(graphGroup.getDescription());
        groupTemplate.setExternalId(graphGroup.getId());
        log.debug("Mapped Graph group to Crowd group {}", (Object)groupTemplate);
        if (returnType == Group.class) {
            return (T)groupTemplate;
        }
        return (T)GroupTemplateWithAttributes.ofGroupWithNoAttributes((Group)groupTemplate);
    }

    public GroupTemplateWithAttributesAndMembershipChanges mapDeltaQueryGroup(GraphDeltaQueryGroup graphGroup, long directoryId) {
        GroupTemplate groupTemplate = new GroupTemplate(graphGroup.getDisplayName(), directoryId);
        groupTemplate.setDescription(graphGroup.getDescription());
        groupTemplate.setExternalId(graphGroup.getId());
        List changedUserMembers = graphGroup.getMembers().stream().filter(member -> member.getType().equals("#microsoft.graph.user")).collect(Collectors.toList());
        List changedGroupMembers = graphGroup.getMembers().stream().filter(member -> member.getType().equals("#microsoft.graph.group")).collect(Collectors.toList());
        return new GroupTemplateWithAttributesAndMembershipChanges((GroupWithAttributes)GroupTemplateWithAttributes.ofGroupWithNoAttributes((Group)groupTemplate), changedUserMembers.stream().filter(member -> member.getRemoved() == null).map(GraphDeltaQueryMembership::getId).collect(Collectors.toSet()), changedUserMembers.stream().filter(member -> member.getRemoved() != null).map(GraphDeltaQueryMembership::getId).collect(Collectors.toSet()), changedGroupMembers.stream().filter(member -> member.getRemoved() == null).map(GraphDeltaQueryMembership::getId).collect(Collectors.toSet()), changedGroupMembers.stream().filter(member -> member.getRemoved() != null).map(GraphDeltaQueryMembership::getId).collect(Collectors.toSet()));
    }

    public <T> T mapDirectoryObject(DirectoryObject directoryObject, Class<T> returnType, long directoryId) {
        if (directoryObject instanceof GraphMembershipGroup) {
            if (returnType == String.class) {
                return (T)directoryObject.getDisplayName();
            }
            GroupTemplate groupTemplate = new GroupTemplate(directoryObject.getDisplayName(), directoryId);
            groupTemplate.setDescription(((GraphMembershipGroup)directoryObject).getDescription());
            groupTemplate.setExternalId(directoryObject.getId());
            log.debug("Mapped Graph group to Crowd group {}", (Object)groupTemplate);
            if (returnType == Group.class) {
                return (T)groupTemplate;
            }
            return (T)GroupTemplateWithAttributes.ofGroupWithNoAttributes((Group)groupTemplate);
        }
        if (directoryObject instanceof GraphMembershipUser) {
            if (returnType == String.class) {
                return (T)((GraphMembershipUser)directoryObject).getUserPrincipalName();
            }
            UserTemplate userTemplate = new UserTemplate(((GraphMembershipUser)directoryObject).getUserPrincipalName(), ((GraphMembershipUser)directoryObject).getGivenName(), ((GraphMembershipUser)directoryObject).getSurname(), directoryObject.getDisplayName());
            userTemplate.setDirectoryId(directoryId);
            userTemplate.setEmailAddress(((GraphMembershipUser)directoryObject).getMail());
            userTemplate.setActive(((GraphMembershipUser)directoryObject).getAccountEnabled() != null ? ((GraphMembershipUser)directoryObject).getAccountEnabled() : true);
            userTemplate.setExternalId(directoryObject.getId());
            log.debug("Mapped Graph user to Crowd user {}", (Object)userTemplate);
            if (returnType == User.class) {
                return (T)userTemplate;
            }
            return (T)UserTemplateWithAttributes.toUserWithNoAttributes((User)userTemplate);
        }
        throw new IllegalArgumentException("Cannot map directory object of type " + directoryObject.getClass());
    }
}

