/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.rest;

import com.atlassian.crowd.directory.query.ODataTop;
import com.atlassian.crowd.directory.rest.AzureAdRestClient;
import com.atlassian.crowd.directory.rest.delta.GraphDeltaQueryResult;
import com.atlassian.crowd.directory.rest.entity.PageableGraphList;
import com.atlassian.crowd.directory.rest.entity.delta.PageableDeltaQueryGraphList;
import com.atlassian.crowd.exception.OperationFailedException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AzureAdPagingWrapper {
    private final AzureAdRestClient azureAdRestClient;

    public AzureAdPagingWrapper(AzureAdRestClient azureAdRestClient) {
        this.azureAdRestClient = azureAdRestClient;
    }

    public <V extends PageableGraphList<T>, T> List<T> fetchAppropriateAmountOfResults(V firstPage, Class<V> resultsClass, int startIndex, int maxResults) throws OperationFailedException {
        int amountOfEntriesToSkip = startIndex;
        ArrayList<T> results = new ArrayList<T>(firstPage.getEntries().stream().skip(amountOfEntriesToSkip).collect(Collectors.toList()));
        amountOfEntriesToSkip -= firstPage.getEntries().size();
        String nextLink = firstPage.getNextLink();
        while (!(maxResults != -1 && results.size() >= maxResults || Strings.isNullOrEmpty((String)nextLink))) {
            V nextPage = this.azureAdRestClient.getNextPage(nextLink, resultsClass, this.calculateNextPageSize(results.size(), maxResults));
            nextLink = ((PageableGraphList)nextPage).getNextLink();
            if (amountOfEntriesToSkip > 0) {
                results.addAll(((PageableGraphList)nextPage).getEntries().stream().skip(amountOfEntriesToSkip).collect(Collectors.toList()));
                amountOfEntriesToSkip -= ((PageableGraphList)nextPage).getEntries().size();
                continue;
            }
            results.addAll(((PageableGraphList)nextPage).getEntries());
        }
        return results;
    }

    public <V extends PageableGraphList<T>, T> List<T> fetchAllMatchingResults(V firstPage, Class<V> resultsClass, Predicate<T> filter) throws OperationFailedException {
        ArrayList results = new ArrayList(firstPage.getEntries().stream().filter(filter).collect(Collectors.toList()));
        String nextLink = firstPage.getNextLink();
        while (!Strings.isNullOrEmpty((String)nextLink)) {
            V nextPage = this.azureAdRestClient.getNextPage(nextLink, resultsClass, ODataTop.FULL_PAGE);
            nextLink = ((PageableGraphList)nextPage).getNextLink();
            results.addAll(((PageableGraphList)nextPage).getEntries().stream().filter(filter).collect(Collectors.toList()));
        }
        return results;
    }

    public <V extends PageableGraphList<T>, T> Optional<T> pageForElement(V firstPage, Class<V> resultsClass, Predicate<T> predicate) throws OperationFailedException {
        String nextLink = firstPage.getNextLink();
        Optional maybeResult = firstPage.getEntries().stream().filter(predicate).findFirst();
        while (!maybeResult.isPresent() && !Strings.isNullOrEmpty((String)nextLink)) {
            V nextPage = this.azureAdRestClient.getNextPage(nextLink, resultsClass, ODataTop.FULL_PAGE);
            nextLink = ((PageableGraphList)nextPage).getNextLink();
            maybeResult = ((PageableGraphList)nextPage).getEntries().stream().filter(predicate).findFirst();
        }
        return maybeResult;
    }

    public <V extends PageableDeltaQueryGraphList<T>, T> GraphDeltaQueryResult<T> fetchAllDeltaQueryResults(V firstPage, Class<V> resultsClass) throws OperationFailedException {
        Object lastPage = firstPage;
        ArrayList results = new ArrayList(firstPage.getEntries());
        String nextLink = firstPage.getNextLink();
        while (!Strings.isNullOrEmpty((String)nextLink)) {
            PageableDeltaQueryGraphList nextPage = (PageableDeltaQueryGraphList)this.azureAdRestClient.getNextPage(nextLink, resultsClass);
            nextLink = nextPage.getNextLink();
            results.addAll(nextPage.getEntries());
            lastPage = nextPage;
        }
        return new GraphDeltaQueryResult(results, lastPage.getDeltaLink());
    }

    @VisibleForTesting
    ODataTop calculateNextPageSize(int currentResults, int maxResults) {
        if (maxResults == -1) {
            return ODataTop.FULL_PAGE;
        }
        int resultsLeft = maxResults - currentResults;
        if (resultsLeft >= 999) {
            return ODataTop.FULL_PAGE;
        }
        return new ODataTop(resultsLeft);
    }
}

