/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.query;

import com.atlassian.crowd.directory.query.FetchMode;
import com.atlassian.crowd.directory.query.GraphQuery;
import com.atlassian.crowd.directory.query.ODataExpand;
import com.atlassian.crowd.directory.query.ODataFilter;
import com.atlassian.crowd.directory.query.ODataSelect;
import com.atlassian.crowd.directory.query.ODataTop;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.BooleanRestriction;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrosoftGraphQueryTranslator {
    public static final String USERNAME = "userPrincipalName";
    static final String FIRST_NAME = "givenName";
    static final String LAST_NAME = "surname";
    static final String DISPLAY_NAME = "displayName";
    static final String MAIL = "mail";
    public static final String ID = "id";
    static final String ACCOUNT_ENABLED = "accountEnabled";
    public static final Set<String> USER_PROPERTIES = ImmutableSet.of((Object)"userPrincipalName", (Object)"givenName", (Object)"surname", (Object)"displayName", (Object)"mail", (Object)"id", (Object[])new String[]{"accountEnabled"});
    public static final Set<String> MINIMAL_USER_PROPERTIES = ImmutableSet.of((Object)"userPrincipalName", (Object)"id");
    public static final String COMMA_SEPARATED_MINIMAL_USER_PROPERTIES = MINIMAL_USER_PROPERTIES.stream().collect(Collectors.joining(","));
    public static final String COMMA_SEPARATED_USER_PROPERTIES = USER_PROPERTIES.stream().collect(Collectors.joining(","));
    public static final String GROUPNAME = "displayName";
    static final String DESCRIPTION = "description";
    static final String MEMBERS = "members";
    public static final Set<String> GROUP_PROPERTIES = ImmutableSet.of((Object)"displayName", (Object)"description", (Object)"id");
    public static final Set<String> DELTA_QUERY_GROUP_PROPERTIES = Stream.concat(GROUP_PROPERTIES.stream(), ImmutableSet.of((Object)"members").stream()).collect(Collectors.toSet());
    public static final Set<String> MINIMAL_GROUP_PROPERTIES = ImmutableSet.of((Object)"displayName", (Object)"id");
    public static final String COMMA_SEPARATED_MINIMAL_GROUP_PROPERTIES = MINIMAL_GROUP_PROPERTIES.stream().collect(Collectors.joining(","));
    public static final String COMMA_SEPARATED_GROUP_PROPERTIES = GROUP_PROPERTIES.stream().collect(Collectors.joining(","));
    public static final String COMMA_SEPARATED_DELTA_QUERY_GROUP_PROPERTIES = DELTA_QUERY_GROUP_PROPERTIES.stream().collect(Collectors.joining(","));
    public static final Set<String> NAME_PROPERTIES = ImmutableSet.of((Object)"userPrincipalName", (Object)"displayName");
    public static final String COMMA_SEPARATED_NAME_PROPERTIES = NAME_PROPERTIES.stream().collect(Collectors.joining(","));
    public static final String COMMA_SEPARATED_USER_AND_GROUP_PROPERTIES = Stream.concat(USER_PROPERTIES.stream(), GROUP_PROPERTIES.stream()).collect(Collectors.joining(","));
    public static final String COMMA_SEPARATED_MINIMAL_USER_AND_GROUP_PROPERTIES = Stream.concat(MINIMAL_USER_PROPERTIES.stream(), MINIMAL_GROUP_PROPERTIES.stream()).collect(Collectors.joining(","));
    private static final String GRAPH_EQUALS_OPERATOR = "eq";
    private static final String GRAPH_LESS_THAN_OPERATOR = "lt";
    private static final String GRAPH_LESS_THAN_OR_EQUAL_OPERATOR = "lte";
    private static final String GRAPH_GREATER_THAN_OPERATOR = "gt";
    private static final String GRAPH_GREATER_THAN_OR_EQUAL_OPERATOR = "gte";
    private static final String GRAPH_STARTS_WITH_FUNCTION = "startswith";
    private static final Logger log = LoggerFactory.getLogger(MicrosoftGraphQueryTranslator.class);

    public GraphQuery convert(EntityQuery query) {
        SearchRestriction searchRestriction = query.getSearchRestriction();
        ODataFilter oDataFilter = this.translateSearchRestriction(query.getEntityDescriptor(), searchRestriction);
        ODataSelect oDataSelect = this.resolveAzureAdColumnsForSingleEntityTypeQuery(query.getEntityDescriptor(), query.getReturnType());
        ODataTop limit = this.resolveQueryLimit(query.getMaxResults());
        return new GraphQuery(oDataFilter, oDataSelect, query.getStartIndex(), limit);
    }

    private ODataTop resolveQueryLimit(int maxResults) {
        if (maxResults == -1 || maxResults > 999) {
            return ODataTop.FULL_PAGE;
        }
        return new ODataTop(maxResults);
    }

    public ODataSelect resolveAzureAdColumnsForSingleEntityTypeQuery(EntityDescriptor entity, Class<?> returnType) {
        FetchMode fetchMode = returnType == String.class ? FetchMode.NAME : FetchMode.FULL;
        return this.resolveAzureAdColumnsForSingleEntityTypeQuery(entity, fetchMode);
    }

    public ODataFilter translateSearchRestriction(EntityDescriptor entityDescriptor, SearchRestriction restriction) {
        if (restriction instanceof PropertyRestriction) {
            return new ODataFilter(this.translatePropertyRestriction(entityDescriptor, (PropertyRestriction)restriction));
        }
        if (restriction instanceof BooleanRestriction) {
            return new ODataFilter(this.translateBooleanRestriction(entityDescriptor, (BooleanRestriction)restriction));
        }
        return ODataFilter.EMPTY;
    }

    public ODataSelect resolveAzureAdColumnsForSingleEntityTypeQuery(EntityDescriptor entity, FetchMode fetchMode) {
        if (entity == EntityDescriptor.user()) {
            switch (fetchMode) {
                case FULL: 
                case DELTA_QUERY: {
                    return new ODataSelect(COMMA_SEPARATED_USER_PROPERTIES);
                }
                case NAME_AND_ID: {
                    return new ODataSelect(COMMA_SEPARATED_MINIMAL_USER_PROPERTIES);
                }
                case NAME: {
                    return new ODataSelect(USERNAME);
                }
                case ID: {
                    return new ODataSelect(ID);
                }
            }
            throw new IllegalArgumentException(String.format("Cannot translate query for entity %s, fetch mode %s", new Object[]{entity, fetchMode}));
        }
        if (entity == EntityDescriptor.group()) {
            switch (fetchMode) {
                case FULL: {
                    return new ODataSelect(COMMA_SEPARATED_GROUP_PROPERTIES);
                }
                case DELTA_QUERY: {
                    return new ODataSelect(COMMA_SEPARATED_DELTA_QUERY_GROUP_PROPERTIES);
                }
                case NAME_AND_ID: {
                    return new ODataSelect(COMMA_SEPARATED_MINIMAL_GROUP_PROPERTIES);
                }
                case NAME: {
                    return new ODataSelect("displayName");
                }
                case ID: {
                    return new ODataSelect(ID);
                }
            }
            throw new IllegalArgumentException(String.format("Cannot translate query for entity %s, fetch mode %s", new Object[]{entity, fetchMode}));
        }
        throw new IllegalArgumentException(String.format("Cannot translate query for entity %s, fetch mode %s", new Object[]{entity, fetchMode}));
    }

    public ODataExpand resolveAzureAdNavigationPropertiesForSingleEntityTypeQuery(EntityDescriptor entity, FetchMode fetchMode) {
        if (entity == EntityDescriptor.group()) {
            switch (fetchMode) {
                case DELTA_QUERY: {
                    return new ODataExpand(MEMBERS);
                }
            }
            throw new IllegalArgumentException(String.format("Cannot translate query for entity %s, fetch mode %s", new Object[]{entity, fetchMode}));
        }
        throw new IllegalArgumentException(String.format("Cannot translate query for entity %s, fetch mode %s", new Object[]{entity, fetchMode}));
    }

    public ODataSelect translateColumnsForUsersAndGroupsQuery(FetchMode fetchMode) {
        switch (fetchMode) {
            case FULL: {
                return new ODataSelect(COMMA_SEPARATED_USER_AND_GROUP_PROPERTIES);
            }
            case NAME_AND_ID: {
                return new ODataSelect(COMMA_SEPARATED_MINIMAL_USER_AND_GROUP_PROPERTIES);
            }
            case NAME: {
                return new ODataSelect(COMMA_SEPARATED_NAME_PROPERTIES);
            }
            case ID: {
                return new ODataSelect(ID);
            }
        }
        throw new IllegalArgumentException(String.format("Cannot translate query for users and groups query, fetch mode %s", new Object[]{fetchMode}));
    }

    private String translateBooleanRestriction(EntityDescriptor entityDescriptor, BooleanRestriction restriction) {
        boolean hasMultipleRestrictions;
        StringBuilder restrictionBuilder = new StringBuilder();
        boolean bl = hasMultipleRestrictions = restriction.getRestrictions().size() > 1;
        if (hasMultipleRestrictions) {
            restrictionBuilder.append("(");
        }
        restrictionBuilder.append(restriction.getRestrictions().stream().map(subrestriction -> this.translateSearchRestriction(entityDescriptor, (SearchRestriction)subrestriction)).map(ODataFilter::asRawValue).collect(Collectors.joining(" " + restriction.getBooleanLogic().name() + " ")));
        if (hasMultipleRestrictions) {
            restrictionBuilder.append(")");
        }
        return restrictionBuilder.toString();
    }

    private String translatePropertyRestriction(EntityDescriptor entityDescriptor, PropertyRestriction restriction) {
        StringBuilder stringBuilder = new StringBuilder();
        String azureAdPropertyName = this.resolvePropertyName(entityDescriptor, restriction.getProperty());
        if (restriction.getMatchMode() == MatchMode.CONTAINS || restriction.getMatchMode() == MatchMode.STARTS_WITH) {
            this.appendODataFunction(restriction, stringBuilder, azureAdPropertyName);
        } else {
            this.appendODataComparison(restriction, stringBuilder, azureAdPropertyName);
        }
        return stringBuilder.toString();
    }

    private void appendODataComparison(PropertyRestriction restriction, StringBuilder stringBuilder, String azureAdPropertyName) {
        stringBuilder.append(azureAdPropertyName).append(" ").append(this.resolveOperator(restriction.getMatchMode())).append(" ");
        if (this.shouldBeQuoted(restriction)) {
            stringBuilder.append("'");
        }
        if (restriction.getMatchMode() == MatchMode.NULL) {
            stringBuilder.append("null");
        } else {
            stringBuilder.append(this.sanitizeOdataValue(restriction.getValue()));
        }
        if (this.shouldBeQuoted(restriction)) {
            stringBuilder.append("'");
        }
    }

    private boolean shouldBeQuoted(PropertyRestriction restriction) {
        return restriction.getProperty().getPropertyType() == String.class && restriction.getMatchMode() != MatchMode.NULL;
    }

    private void appendODataFunction(PropertyRestriction restriction, StringBuilder stringBuilder, String azureAdPropertyName) {
        boolean isStringRestriction;
        stringBuilder.append(this.resolveOperatorFunction(restriction.getMatchMode())).append("(").append(this.sanitizeOdataValue(azureAdPropertyName)).append(",");
        boolean bl = isStringRestriction = restriction.getProperty().getPropertyType() == String.class;
        if (isStringRestriction) {
            stringBuilder.append("'");
        }
        stringBuilder.append(this.sanitizeOdataValue(restriction.getValue()));
        if (isStringRestriction) {
            stringBuilder.append("'");
        }
        stringBuilder.append(")");
    }

    private String resolveOperatorFunction(MatchMode matchMode) {
        switch (matchMode) {
            case CONTAINS: {
                log.warn("Contains query is not supported for Azure AD directories, using starts with instead");
            }
            case STARTS_WITH: {
                return GRAPH_STARTS_WITH_FUNCTION;
            }
        }
        throw new IllegalArgumentException("Cannot query by match mode " + matchMode);
    }

    private String resolveOperator(MatchMode matchMode) {
        switch (matchMode) {
            case EXACTLY_MATCHES: 
            case NULL: {
                return GRAPH_EQUALS_OPERATOR;
            }
            case GREATER_THAN: {
                return GRAPH_GREATER_THAN_OPERATOR;
            }
            case GREATER_THAN_OR_EQUAL: {
                return GRAPH_GREATER_THAN_OR_EQUAL_OPERATOR;
            }
            case LESS_THAN: {
                return GRAPH_LESS_THAN_OPERATOR;
            }
            case LESS_THAN_OR_EQUAL: {
                return GRAPH_LESS_THAN_OR_EQUAL_OPERATOR;
            }
        }
        throw new IllegalArgumentException("Cannot query by match mode " + matchMode);
    }

    private String resolvePropertyName(EntityDescriptor entityDescriptor, Property property) {
        switch (entityDescriptor.getEntityType()) {
            case USER: {
                return this.getUserAttributeName(property);
            }
            case GROUP: {
                return this.getGroupAttributeName(property);
            }
        }
        throw new IllegalArgumentException("Cannot transform entity of type <" + entityDescriptor.getEntityType() + ">");
    }

    private String getGroupAttributeName(Property property) {
        if (GroupTermKeys.NAME.equals(property)) {
            return "displayName";
        }
        if (GroupTermKeys.DESCRIPTION.equals(property)) {
            return DESCRIPTION;
        }
        throw new IllegalArgumentException("Cannot query by property " + property);
    }

    private String getUserAttributeName(Property property) {
        if (UserTermKeys.USERNAME.equals(property)) {
            return USERNAME;
        }
        if (UserTermKeys.FIRST_NAME.equals(property)) {
            return FIRST_NAME;
        }
        if (UserTermKeys.LAST_NAME.equals(property)) {
            return LAST_NAME;
        }
        if (UserTermKeys.DISPLAY_NAME.equals(property)) {
            return "displayName";
        }
        if (UserTermKeys.EMAIL.equals(property)) {
            return MAIL;
        }
        if (UserTermKeys.EXTERNAL_ID.equals(property)) {
            return ID;
        }
        if (UserTermKeys.ACTIVE.equals(property)) {
            return ACCOUNT_ENABLED;
        }
        throw new IllegalArgumentException("Cannot query by property " + property);
    }

    private <T> T sanitizeOdataValue(T value) {
        if (value instanceof String) {
            return (T)((String)value).replace("'", "''");
        }
        return value;
    }
}

