/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.rest;

import com.atlassian.crowd.directory.authentication.AdalAuthenticationContextFactory;
import com.atlassian.crowd.directory.authentication.AzureAdRefreshTokenFilter;
import com.atlassian.crowd.directory.authentication.AzureAdTokenRefresher;
import com.atlassian.crowd.directory.authentication.impl.AuthorityUrlProvider;
import com.atlassian.crowd.directory.authentication.impl.SameThreadAdalAuthenticator;
import com.atlassian.crowd.directory.rest.AzureAdPagingWrapper;
import com.atlassian.crowd.directory.rest.AzureAdRestClient;
import com.atlassian.crowd.directory.rest.AzureAdRestClientFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;

public class DefaultAzureAdRestClientFactory
implements AzureAdRestClientFactory {
    private final AdalAuthenticationContextFactory authenticationContextFactory;

    public DefaultAzureAdRestClientFactory(AdalAuthenticationContextFactory authenticationContextFactory) {
        this.authenticationContextFactory = authenticationContextFactory;
    }

    @Override
    public AzureAdRestClient create(String clientId, String clientSecret, String tenantId) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)tenantId), (Object)"Tenant ID not specified");
        Client jerseyClient = this.createJerseyClient(clientId, clientSecret, tenantId);
        return new AzureAdRestClient(jerseyClient);
    }

    protected Client createJerseyClient(String clientId, String clientSecret, String tenantId) {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getSingletons().add(new JacksonJaxbJsonProvider());
        Client jerseyClient = Client.create((ClientConfig)config);
        SameThreadAdalAuthenticator adalAuthenticator = new SameThreadAdalAuthenticator(this.authenticationContextFactory, clientId, clientSecret, AuthorityUrlProvider.generateAuthorityUrl(tenantId));
        jerseyClient.addFilter((ClientFilter)this.createAzureAdTokenFilter(adalAuthenticator));
        return jerseyClient;
    }

    @Override
    public AzureAdPagingWrapper create(AzureAdRestClient restClient) {
        return new AzureAdPagingWrapper(restClient);
    }

    private AzureAdRefreshTokenFilter createAzureAdTokenFilter(SameThreadAdalAuthenticator adalAuthenticator) {
        return new AzureAdRefreshTokenFilter(this.createAzureAdTokenRefresher(adalAuthenticator));
    }

    private AzureAdTokenRefresher createAzureAdTokenRefresher(final SameThreadAdalAuthenticator adalAuthenticator) {
        return new AzureAdTokenRefresher((LoadingCache<String, String>)CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

            public String load(String key) throws Exception {
                Preconditions.checkArgument((boolean)"AZURE_AD_TOKEN".equals(key));
                return adalAuthenticator.getAdalAuthenticationToken().getAccessToken();
            }
        }));
    }
}

