/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.rest;

import com.atlassian.crowd.directory.query.GraphQuery;
import com.atlassian.crowd.directory.query.MicrosoftGraphQueryParam;
import com.atlassian.crowd.directory.query.ODataSelect;
import com.atlassian.crowd.directory.query.ODataTop;
import com.atlassian.crowd.directory.rest.entity.GraphDirectoryObjectList;
import com.atlassian.crowd.directory.rest.entity.PageableGraphList;
import com.atlassian.crowd.directory.rest.entity.delta.GraphDeltaQueryGroupList;
import com.atlassian.crowd.directory.rest.entity.delta.GraphDeltaQueryUserList;
import com.atlassian.crowd.directory.rest.entity.group.GraphGroupList;
import com.atlassian.crowd.directory.rest.entity.user.GraphUsersList;
import com.atlassian.crowd.exception.OperationFailedException;
import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.net.URI;
import java.util.function.Supplier;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;

public class AzureAdRestClient {
    public static final String GRAPH_BASE_ENDPOINT = "https://graph.microsoft.com";
    public static final String GRAPH_API_VERSION = "/v1.0";
    public static final String GRAPH_USERS_ENDPOINT_SUFFIX = "users";
    public static final String GRAPH_GROUPS_ENDPOINT_SUFFIX = "groups";
    public static final String MEMBER_OF_NAVIGATIONAL_PROPERTY = "memberOf";
    public static final String MEMBERS_NAVIGATIONAL_PROPERTY = "members";
    public static final String DELTA_QUERY_ENDPOINT_SUFFIX = "delta";
    private final Client client;
    private final String graphBaseEndpoint;

    public AzureAdRestClient(Client client) {
        this.client = client;
        this.graphBaseEndpoint = GRAPH_BASE_ENDPOINT;
    }

    @VisibleForTesting
    public AzureAdRestClient(Client client, String graphBaseEndpoint) {
        this.client = client;
        this.graphBaseEndpoint = graphBaseEndpoint;
    }

    public GraphUsersList searchUsers(GraphQuery query) throws OperationFailedException {
        return this.handleRequest(() -> (GraphUsersList)this.client.resource(this.getGraphBaseResource()).path(GRAPH_USERS_ENDPOINT_SUFFIX).queryParams(query.getFilter().asQueryParam()).queryParams(query.getSelect().asQueryParam()).queryParams(query.getLimit().asQueryParam()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(GraphUsersList.class));
    }

    public GraphGroupList searchGroups(GraphQuery query) throws OperationFailedException {
        return this.handleRequest(() -> (GraphGroupList)this.client.resource(this.getGraphBaseResource()).path(GRAPH_GROUPS_ENDPOINT_SUFFIX).queryParams(query.getFilter().asQueryParam()).queryParams(query.getSelect().asQueryParam()).queryParams(query.getLimit().asQueryParam()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(GraphGroupList.class));
    }

    public GraphDirectoryObjectList getDirectParentsOfUser(String nameOrExternalId, ODataSelect select) throws OperationFailedException {
        return this.handleRequest(() -> (GraphDirectoryObjectList)this.client.resource(this.getGraphBaseResource()).path(GRAPH_USERS_ENDPOINT_SUFFIX).path(nameOrExternalId).path(MEMBER_OF_NAVIGATIONAL_PROPERTY).queryParams(ODataTop.FULL_PAGE.asQueryParam()).queryParams(select.asQueryParam()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(GraphDirectoryObjectList.class));
    }

    public GraphDirectoryObjectList getDirectParentsOfGroup(String groupId, ODataSelect select) throws OperationFailedException {
        return this.handleRequest(() -> (GraphDirectoryObjectList)this.client.resource(this.getGraphBaseResource()).path(GRAPH_GROUPS_ENDPOINT_SUFFIX).path(groupId).path(MEMBER_OF_NAVIGATIONAL_PROPERTY).queryParams(ODataTop.FULL_PAGE.asQueryParam()).queryParams(select.asQueryParam()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(GraphDirectoryObjectList.class));
    }

    public GraphDirectoryObjectList getDirectChildrenOfGroup(String groupId, ODataSelect select) throws OperationFailedException {
        return this.handleRequest(() -> (GraphDirectoryObjectList)this.client.resource(this.getGraphBaseResource()).path(GRAPH_GROUPS_ENDPOINT_SUFFIX).path(groupId).path(MEMBERS_NAVIGATIONAL_PROPERTY).queryParams(select.asQueryParam()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(GraphDirectoryObjectList.class));
    }

    public GraphDeltaQueryUserList performUsersDeltaQuery(MicrosoftGraphQueryParam parameter) throws OperationFailedException {
        return this.handleRequest(() -> (GraphDeltaQueryUserList)this.client.resource(this.getGraphBaseResource()).path(GRAPH_USERS_ENDPOINT_SUFFIX).path(DELTA_QUERY_ENDPOINT_SUFFIX).queryParams(parameter.asQueryParam()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(GraphDeltaQueryUserList.class));
    }

    public GraphDeltaQueryGroupList performGroupsDeltaQuery(MicrosoftGraphQueryParam parameter) throws OperationFailedException {
        return this.handleRequest(() -> (GraphDeltaQueryGroupList)this.client.resource(this.getGraphBaseResource()).path(GRAPH_GROUPS_ENDPOINT_SUFFIX).path(DELTA_QUERY_ENDPOINT_SUFFIX).queryParams(parameter.asQueryParam()).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(GraphDeltaQueryGroupList.class));
    }

    private String getGraphBaseResource() {
        return this.graphBaseEndpoint + GRAPH_API_VERSION;
    }

    public <T extends PageableGraphList> T getNextPage(String nextLink, Class<T> resultsClass) throws OperationFailedException {
        return (T)this.handleRequest(() -> (PageableGraphList)this.client.resource(nextLink).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(resultsClass));
    }

    public <T extends PageableGraphList> T getNextPage(String nextLink, Class<T> resultsClass, ODataTop limit) throws OperationFailedException {
        URI nextLinkWithUpdatedLimit = UriBuilder.fromUri((String)nextLink).replaceQueryParam("$top", new Object[]{limit.asRawValue()}).build(new Object[0]);
        return (T)this.handleRequest(() -> (PageableGraphList)this.client.resource(nextLinkWithUpdatedLimit).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(resultsClass));
    }

    private <T> T handleRequest(Supplier<T> requestSupplier) throws OperationFailedException {
        try {
            return requestSupplier.get();
        }
        catch (UniformInterfaceException e) {
            String message = String.format("Microsoft Graph API has returned an error response. Response status code: %d, content %s", e.getResponse().getStatus(), e.getResponse().getEntity(String.class));
            throw new OperationFailedException(message);
        }
    }
}

