/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.AzureAdDirectory;
import com.atlassian.crowd.directory.query.FetchMode;
import com.atlassian.crowd.directory.query.GraphQuery;
import com.atlassian.crowd.directory.query.MicrosoftGraphQueryTranslator;
import com.atlassian.crowd.directory.query.ODataFilter;
import com.atlassian.crowd.directory.query.ODataSelect;
import com.atlassian.crowd.directory.query.ODataTop;
import com.atlassian.crowd.directory.rest.AzureAdPagingWrapper;
import com.atlassian.crowd.directory.rest.AzureAdRestClient;
import com.atlassian.crowd.directory.rest.entity.GraphDirectoryObjectList;
import com.atlassian.crowd.directory.rest.entity.group.GraphGroup;
import com.atlassian.crowd.directory.rest.entity.group.GraphGroupList;
import com.atlassian.crowd.directory.rest.entity.membership.DirectoryObject;
import com.atlassian.crowd.directory.rest.mapper.AzureAdRestEntityMapper;
import com.atlassian.crowd.directory.rest.util.MembershipFilterUtil;
import com.atlassian.crowd.directory.rest.util.ThrowingMapMergeOperatorUtil;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.ImmutableMembership;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.crowd.search.EntityDescriptor;
import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AzureAdDirectoryMembershipsIterable
implements Iterable<Membership> {
    private final Map<String, String> groupNamesToIds;
    private AzureAdRestClient restClient;
    private AzureAdPagingWrapper pagingWrapper;
    private MicrosoftGraphQueryTranslator queryTranslator;
    private AzureAdRestEntityMapper restEntityMapper;
    private AzureAdDirectory directory;
    private final Function<Map.Entry<String, String>, Membership> lookUpMembers = entry -> {
        try {
            return this.get((String)entry.getKey(), (String)entry.getValue());
        }
        catch (OperationFailedException e) {
            throw new Membership.MembershipIterationException((Throwable)e);
        }
    };

    public AzureAdDirectoryMembershipsIterable(AzureAdRestClient restClient, AzureAdPagingWrapper pagingWrapper, MicrosoftGraphQueryTranslator queryTranslator, AzureAdRestEntityMapper restEntityMapper, AzureAdDirectory directory) throws OperationFailedException {
        this.restClient = restClient;
        this.pagingWrapper = pagingWrapper;
        this.queryTranslator = queryTranslator;
        this.restEntityMapper = restEntityMapper;
        this.directory = directory;
        ODataSelect select = queryTranslator.resolveAzureAdColumnsForSingleEntityTypeQuery(EntityDescriptor.group(), FetchMode.NAME_AND_ID);
        GraphQuery query = new GraphQuery(ODataFilter.EMPTY, select, 0, ODataTop.FULL_PAGE);
        List<GraphGroup> groups = pagingWrapper.fetchAppropriateAmountOfResults(restClient.searchGroups(query), GraphGroupList.class, 0, -1);
        this.groupNamesToIds = groups.stream().collect(Collectors.toMap(GraphGroup::getDisplayName, GraphGroup::getId, ThrowingMapMergeOperatorUtil.duplicateAzureAdGroupsThrowingMerger(groups)));
    }

    private Membership get(String groupName, String groupId) throws OperationFailedException {
        ODataSelect select = this.queryTranslator.translateColumnsForUsersAndGroupsQuery(FetchMode.NAME);
        boolean supportsNestedGroups = this.directory.supportsNestedGroups();
        List<DirectoryObject> groupChildren = this.pagingWrapper.fetchAllMatchingResults(this.restClient.getDirectChildrenOfGroup(groupId, select), GraphDirectoryObjectList.class, dirObject -> MembershipFilterUtil.isUser(dirObject) || supportsNestedGroups && MembershipFilterUtil.isGroup(dirObject));
        Set userNames = groupChildren.stream().filter(MembershipFilterUtil::isUser).map(directoryObject -> this.restEntityMapper.mapDirectoryObject((DirectoryObject)directoryObject, String.class, this.directory.getDirectoryId())).collect(Collectors.toSet());
        Set groupNames = supportsNestedGroups ? groupChildren.stream().filter(MembershipFilterUtil::isGroup).map(directoryObject -> this.restEntityMapper.mapDirectoryObject((DirectoryObject)directoryObject, String.class, this.directory.getDirectoryId())).collect(Collectors.toSet()) : Collections.emptySet();
        return new ImmutableMembership(groupName, userNames, groupNames);
    }

    @Override
    public Iterator<Membership> iterator() {
        return Iterators.transform(this.groupNamesToIds.entrySet().iterator(), this.lookUpMembers);
    }
}

