package com.atlassian.crowd.validator;

import java.util.List;

/**
 * Validates email address(es).
 *
 * @since 4.4.0
 */
public interface EmailAddressValidator {

    /**
     * Validates whether email address has valid syntax.
     *
     * @param emailAddress email address to validate
     * @return true if email address has valid syntax, false otherwise
     */
    boolean isValidSyntax(String emailAddress);

    /**
     * Validates syntax of provided email addresses.
     * <p>
     * Note about duplicates: if provided email addresses contain duplicates which have invalid syntax, they are counted
     * as separate email addresses.
     * <p>
     * For example, for given list of email addresses:
     * - validemail@validemail.com
     * - invalidDuplicatedEmail@
     * - invalidEmail
     * - invalidDuplicatedEmail@
     * the method will return 3.
     *
     * @param emailAddresses list of email addresses
     * @return number of invalid email addresses
     */
    long validateSyntax(List<String> emailAddresses);

    /**
     * Finds duplicate in a given list of email addresses.
     * <p>
     * For example, for given list of email addresses:
     * - validemail@validemail.com
     * - validduplicatedemail@validduplicatedemail
     * - validduplicatedemail@validduplicatedemail
     * - invalid
     * - invalidduplicated@
     * - invalidduplicated@
     * the method will return 4.
     *
     * @param emailAddresses list of email addresses
     * @return number of duplicated email addresses
     */
    long findDuplicates(List<String> emailAddresses);
}
