package com.atlassian.crowd.model.token;

import javax.annotation.Nullable;

/**
 * This represents a token with a limited lifetime, associated with a user (by email address and/or username).
 * <p>
 * This can be used for instance for an invite user token. Actual token type is specified by
 * {@link ExpirableUserTokenType}
 *
 * @since v2.8
 */
public interface ExpirableUserToken {
    /**
     * A unique token.
     *
     * @return the token
     */
    String getToken();

    /**
     * A username that can be associated with the token.
     *
     * @return a username or null
     */
    @Nullable
    String getUsername();

    /**
     * An email address that can be associated with the token.
     *
     * @return an email address or null
     */
    @Nullable
    String getEmailAddress();

    /**
     * The date at which the token expires, in millis since the epoch.
     *
     * @return a date
     */
    long getExpiryDate();

    /**
     * The ID of the directory associated with the token.
     *
     * This can be used, for instance, to know in which directory to create an invited user.
     *
     * @return the ID of the directory associated with the token
     */
    long getDirectoryId();

    /**
     * Type of the token, specifying with what feature in Crowd a given token is associated.
     *
     * @since 4.4.0
     */
    ExpirableUserTokenType getType();
}
