package com.atlassian.crowd.model.application;

import java.util.Map;

public final class BooleanAttributeUtil {

    private BooleanAttributeUtil() {}

    static boolean getBooleanAttribute(final Map<String, String> attributes, final String name) {
        return Boolean.parseBoolean(attributes.get(name));
    }

    static void setBooleanAttribute(final Map<String, String> attributes, final String name, final boolean value) {
        attributes.put(name, Boolean.toString(value));
    }
}
