package com.atlassian.crowd.model;

import com.atlassian.crowd.model.application.ApplicationType;

/**
 * Application subtypes.
 */
public enum ApplicationSubtype {
    JIRA_CORE("jira-core", "Jira Core"),
    JIRA_SERVICE_DESK("jira-servicedesk", "Jira Service Desk"),
    JIRA_SOFTWARE("jira-software", "Jira Software"),
    CONFLUENCE("confluence", "Confluence"),
    BITBUCKET("bitbucket", "Bitbucket");

    private String value;
    private String displayName;

    ApplicationSubtype(String value, String displayName) {
        this.value = value;
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getValue() {
        return value;
    }

    public static ApplicationSubtype toEnum(String value) {
        for (ApplicationSubtype v : values())
            if (v.getValue().equalsIgnoreCase(value)) return v;
        throw new IllegalArgumentException(value);
    }

    public static ApplicationSubtype getOnlySubtype(ApplicationType applicationType) {
        switch (applicationType) {
            case CONFLUENCE:
                return ApplicationSubtype.CONFLUENCE;
            case STASH:
                return ApplicationSubtype.BITBUCKET;
            default:
                throw new IllegalArgumentException("No default subtype for: " + applicationType);
        }
    }
}
