package com.atlassian.crowd.manager.audit;

import java.util.Objects;

/**
 * Represents configuration for the audit log
 */
public class AuditLogConfiguration {
    private final RetentionPeriod retentionPeriod;

    /**
     * Creates a configuration instance
     *
     * @param retentionPeriod period after which audit log entries will be removed
     */
    public AuditLogConfiguration(RetentionPeriod retentionPeriod) {
        this.retentionPeriod = retentionPeriod;
    }

    /**
     * Creates a new default configuration instance with the default retention period
     *
     * @return new default configuration instance
     */
    public static AuditLogConfiguration defaultConfiguration() {
        return new AuditLogConfiguration(RetentionPeriod.SIX_MONTHS);
    }

    /**
     * Returns period specifying what is maximum audit log entry length of life
     * Returns an empty optional when retention is unlimited
     *
     * @return retention period
     */
    public RetentionPeriod getRetentionPeriod() {
        return retentionPeriod;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AuditLogConfiguration that = (AuditLogConfiguration) o;
        return retentionPeriod == that.retentionPeriod;
    }

    @Override
    public int hashCode() {
        return Objects.hash(retentionPeriod);
    }
}
