package com.atlassian.crowd.util.mail;

import javax.mail.internet.InternetAddress;
import java.util.Objects;

/**
 * POJO holding SMTP server config.
 */
public class SMTPServer {
    private final String host;
    private final String username;
    private final String password;
    private final InternetAddress from;
    private final String prefix;
    private final String jndiLocation;
    private final int port;
    private final boolean jndiMailActive;
    private final boolean useSSL;
    private final int timeout;

    public static final int DEFAULT_MAIL_PORT = 25;
    public static final int DEFAULT_TIMEOUT = 60;

    /**
     * @deprecated Use {@link com.atlassian.crowd.util.mail.SMTPServer.Builder} instead. Since 3.2
     */
    @Deprecated
    public SMTPServer(String jndiLocation, InternetAddress from, String prefix) {
        this(SMTPServer.builder()
                .setJndiMailActive(true)
                .setJndiLocation(jndiLocation)
                .setFrom(from)
                .setPrefix(prefix));
    }

    /**
     * @deprecated Use {@link com.atlassian.crowd.util.mail.SMTPServer.Builder} instead. Since 3.2
     */
    @Deprecated
    public SMTPServer(int port, String prefix, InternetAddress from, String password, String username, String host, boolean useSSL) {
        this(SMTPServer.builder()
                .setJndiMailActive(false)
                .setPort(port)
                .setPrefix(prefix)
                .setFrom(from)
                .setPassword(password)
                .setUsername(username)
                .setHost(host)
                .setUseSSL(useSSL)
        );
    }

    /**
     * @deprecated Use {@link com.atlassian.crowd.util.mail.SMTPServer.Builder} instead. Since 3.2
     */
    @Deprecated
    public SMTPServer() {
        this(SMTPServer.builder());
    }

    private SMTPServer(SMTPServer.Builder builder) {
        this.host = builder.host;
        this.username = builder.username;
        this.password = builder.password;
        this.from = builder.from;
        this.prefix = builder.prefix;
        this.jndiLocation = builder.jndiLocation;
        this.port = builder.port;
        this.jndiMailActive = builder.jndiMailActive;
        this.useSSL = builder.useSSL;
        this.timeout = builder.timeout;
    }

    public static SMTPServer.Builder builder() {
      return new Builder();
    }

    public static SMTPServer.Builder builder(SMTPServer smtpServer) {
        return new Builder(smtpServer);
    }

    public String getHost() {
        return host;
    }

    public String getUsername() {
        return username;
    }

    public String getPassword() {
        return password;
    }

    public boolean getUseSSL() {
        return useSSL;
    }

    public InternetAddress getFrom() {
        return from;
    }

    public String getPrefix() {
        return prefix;
    }

    public int getPort() {
        return port;
    }

    public String getJndiLocation() {
        return jndiLocation;
    }

    public boolean isJndiMailActive() {
        return jndiMailActive;
    }

    public int getTimeout() {
        return timeout;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SMTPServer that = (SMTPServer) o;
        return port == that.port &&
                jndiMailActive == that.jndiMailActive &&
                useSSL == that.useSSL &&
                timeout == that.timeout &&
                Objects.equals(host, that.host) &&
                Objects.equals(username, that.username) &&
                Objects.equals(password, that.password) &&
                Objects.equals(from, that.from) &&
                Objects.equals(prefix, that.prefix) &&
                Objects.equals(jndiLocation, that.jndiLocation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(host, username, password, from, prefix, jndiLocation, port, jndiMailActive, useSSL, timeout);
    }

    public static final class Builder {
        private String host;
        private String username;
        private String password;
        private InternetAddress from;
        private String prefix;
        private String jndiLocation;
        private int port;
        private boolean jndiMailActive;
        private boolean useSSL;
        private int timeout;

        private Builder() {
        }

        private Builder(SMTPServer smtpServer) {
            this.host = smtpServer.getHost();
            this.username = smtpServer.getUsername();
            this.password = smtpServer.getPassword();
            this.from = smtpServer.getFrom();
            this.prefix = smtpServer.getPrefix();
            this.jndiLocation = smtpServer.getJndiLocation();
            this.port = smtpServer.getPort();
            this.jndiMailActive = smtpServer.isJndiMailActive();
            this.useSSL = smtpServer.getUseSSL();
            this.timeout = smtpServer.getTimeout();
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setFrom(InternetAddress from) {
            this.from = from;
            return this;
        }

        public Builder setPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder setJndiLocation(String jndiLocation) {
            this.jndiLocation = jndiLocation;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setJndiMailActive(boolean jndiMailActive) {
            this.jndiMailActive = jndiMailActive;
            return this;
        }

        public Builder setUseSSL(boolean useSSL) {
            this.useSSL = useSSL;
            return this;
        }

        public Builder setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public SMTPServer build() {
            return new SMTPServer(this);
        }
    }
}
