package com.atlassian.crowd.util;

import java.util.Objects;

public class BatchResultEntityWithCause {
    private final String entityName;
    private final String reason;

    public BatchResultEntityWithCause(String entityName, String reason) {
        this.entityName = entityName;
        this.reason = reason;
    }

    public String getEntityName() {
        return entityName;
    }

    public String getReason() {
        return reason;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BatchResultEntityWithCause that = (BatchResultEntityWithCause) o;
        return Objects.equals(entityName, that.entityName) &&
                Objects.equals(reason, that.reason);
    }

    @Override
    public int hashCode() {
        return Objects.hash(entityName, reason);
    }
}