package com.atlassian.crowd.support;

import java.util.Map;

import com.atlassian.crowd.embedded.api.User;


/**
 * Provides information for support about the configured directories. It is used in the Embedded Crowd UI
 * and by the Support Tools Plugin.
 *
 * @since 2.6.2
 */
public interface SupportInformationService {
    /**
     * Returns a human-readable string containing basic user, directory and application data valuable in support requests.
     *
     * @param currentUser currently logged-in user
     * @return string formatted as "property=value\n"
     */
    String getSupportInformation(User currentUser);

    /**
     * Returns the same data as {@link #getSupportInformation(User)} in map format.
     *
     * @param currentUser currently logged-in user
     * @return flat map containing support information, with keys formatted as "category.subcategory(...).attribute"
     * @since 2.11
     */
    Map<String, String> getSupportInformationMap(User currentUser);
}
