package com.atlassian.crowd.model.lookandfeel;

import com.google.common.base.MoreObjects;

import java.util.Objects;

public class LookAndFeelConfiguration {

    private final boolean showLogo;
    private final String customLogoId;
    private final String header;
    private final String welcomeText;
    private final String primaryColor;

    public LookAndFeelConfiguration() {
        showLogo = false;
        customLogoId = null;
        header = null;
        welcomeText = null;
        primaryColor = null;
    }

    private LookAndFeelConfiguration(Builder builder) {
        this.showLogo = builder.showLogo;
        this.customLogoId = builder.customLogoId;
        this.header = builder.header;
        this.welcomeText = builder.welcomeText;
        this.primaryColor = builder.primaryColor;
    }

    public static LookAndFeelConfiguration.Builder builder() {
        return new Builder();
    }

    public static LookAndFeelConfiguration.Builder builder(LookAndFeelConfiguration lookAndFeelConfiguration) {
        return new Builder(lookAndFeelConfiguration);
    }

    public boolean isShowLogo() {
        return showLogo;
    }

    public String getCustomLogoId() {
        return customLogoId;
    }

    public String getHeader() {
        return header;
    }

    public String getWelcomeText() {
        return welcomeText;
    }

    public String getPrimaryColor() {
        return primaryColor;
    }

    public static final class Builder {
        private boolean showLogo;
        private String customLogoId;
        private String header;
        private String welcomeText;
        private String primaryColor;


        private Builder() {
        }

        private Builder(LookAndFeelConfiguration lookAndFeelConfiguration) {
            this.showLogo = lookAndFeelConfiguration.isShowLogo();
            this.customLogoId = lookAndFeelConfiguration.getCustomLogoId();
            this.header = lookAndFeelConfiguration.getHeader();
            this.welcomeText = lookAndFeelConfiguration.getWelcomeText();
            this.primaryColor = lookAndFeelConfiguration.getPrimaryColor();
        }

        public Builder setShowLogo(boolean showLogo) {
            this.showLogo = showLogo;
            return this;
        }

        public Builder setCustomLogoId(String customLogoId) {
            this.customLogoId = customLogoId;
            return this;
        }

        public Builder setHeader(String header) {
            this.header = header;
            return this;
        }

        public Builder setWelcomeText(String welcomeText) {
            this.welcomeText = welcomeText;
            return this;
        }

        public Builder setPrimaryColor(String primaryColor) {
            this.primaryColor = primaryColor;
            return this;
        }

        public LookAndFeelConfiguration build() {
            return new LookAndFeelConfiguration(this);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LookAndFeelConfiguration that = (LookAndFeelConfiguration) o;
        return Objects.equals(showLogo, that.showLogo) &&
                Objects.equals(customLogoId, that.customLogoId) &&
                Objects.equals(header, that.header) &&
                Objects.equals(welcomeText, that.welcomeText) &&
                Objects.equals(primaryColor, that.primaryColor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(showLogo, customLogoId, header, welcomeText, primaryColor);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("showLogo", showLogo)
                .add("customLogoId", customLogoId)
                .add("header", header)
                .add("welcomeText", welcomeText)
                .add("primaryColor", primaryColor)
                .toString();
    }
}
