package com.atlassian.crowd.manager.sso;

/**
 * Exception thrown when application was not configured for the SSO.
 */
public class ApplicationSamlConfigurationNotFoundException extends RuntimeException {
    private final String assertionConsumerUrl;
    private final String audience;

    public ApplicationSamlConfigurationNotFoundException(String audience, String assertionConsumerUrl) {
        super(String.format("Could not find configuration for application with Assertion Consumer Service URL %s and Issuer %s",
                assertionConsumerUrl, audience));
        this.assertionConsumerUrl = assertionConsumerUrl;
        this.audience = audience;
    }

    public String getAssertionConsumerUrl() {
        return assertionConsumerUrl;
    }

    public String getAudience() {
        return audience;
    }
}
