package com.atlassian.crowd.manager.crypto;

import java.util.Collection;
import java.util.Optional;

/**
 * Manager for in-database passwords encryption.
 */
public interface EncryptionManager {

    /**
     * Changes currently used encryptor to the new one represented by encryptorKey.
     * Encrypts all passwords with the new encryptor.
     */
    void changeEncryptor(String encryptorKey);

    /**
     * Changes currently used encryption key to new one if applicable for current encryptor.
     */
    void changeEncryptionKey();

    /**
     * Returns names of available encryptors.
     */
    Collection<String> getAvailableEncryptorNames();

    /**
     * Returns name of default encryptor.
     */
    Optional<String> getDefaultEncryptorName();

    /**
     * Disables encryption, and decrypts all passwords.
     */
    void disableEncryption();
}
