package com.atlassian.crowd.audit.query;

import com.atlassian.annotations.ExperimentalApi;
import com.google.common.base.Preconditions;

/**
 * A restriction for an affected object of an audit log entry. The criteria of this restriction are a conjunction, all of them
 * must be met for an entry to match.
 */
@ExperimentalApi
public class AuditLogQueryEntityRestriction extends AbstractAuditLogQueryRestriction {
    /**
     * A restriction that matches all entities. Useful to match all entities of the specified type
     */
    public static final AuditLogQueryEntityRestriction NULL_RESTRICTION = new AuditLogQueryEntityRestriction(null, null, null);

    AuditLogQueryEntityRestriction(Long id, String name, String namePrefix) {
        super(name, id, namePrefix);
    }

    /**
     * A restriction matching entities with the given id
     */
    public static AuditLogQueryEntityRestriction id(Long id) {
        return new AuditLogQueryEntityRestriction(Preconditions.checkNotNull(id), null, null);
    }

    /**
     * A restriction matching entities with the given name
     */
    public static AuditLogQueryEntityRestriction name(String name) {
        return new AuditLogQueryEntityRestriction(null, Preconditions.checkNotNull(name), null);
    }

    /**
     * A restriction matching entities with the given name prefix
     */
    public static AuditLogQueryEntityRestriction namePrefix(String namePrefix) {
        return new AuditLogQueryEntityRestriction(null, null, Preconditions.checkNotNull(namePrefix));
    }

}
