package com.atlassian.crowd.audit.query;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.crowd.audit.AuditLogAuthorType;
import com.google.common.base.MoreObjects;

import java.util.Objects;

/**
 * A restriction for an author of an audit log changeset. The criteria of this restriction are a conjunction, all of them
 * must be met for an entry to match.
 */
@ExperimentalApi
public class AuditLogQueryAuthorRestriction extends AuditLogQueryEntityRestriction {
    private final AuditLogAuthorType type;

    private AuditLogQueryAuthorRestriction(Long id, String name, String namePrefix, AuditLogAuthorType type) {
        super(id, name, namePrefix);
        this.type = type;
    }

    /**
     * Match authors with the given id and type
     */
    public static AuditLogQueryAuthorRestriction id(Long id, AuditLogAuthorType type) {
        return new AuditLogQueryAuthorRestriction(id, null, null, type);
    }

    /**
     * Match authors with the given name and type
     */
    public static AuditLogQueryAuthorRestriction name(String name, AuditLogAuthorType type) {
        return new AuditLogQueryAuthorRestriction(null, name, null, type);
    }

    /**
     * Match authors with the given name prefix and type
     */
    public static AuditLogQueryAuthorRestriction namePrefix(String namePrefix, AuditLogAuthorType type) {
        return new AuditLogQueryAuthorRestriction(null, null, namePrefix, type);
    }

    /**
     * Match authors with the given type
     */
    public static AuditLogQueryAuthorRestriction type(AuditLogAuthorType type) {
        return new AuditLogQueryAuthorRestriction(null, null, null, type);
    }

    public AuditLogAuthorType getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuditLogQueryAuthorRestriction that = (AuditLogQueryAuthorRestriction) o;
        return type == that.type;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), type);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                .add("type", type)
                .toString();
    }
}
