/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.application;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ImmutableApplication
implements Application {
    private static final long serialVersionUID = 161484258407244241L;
    private final Long id;
    private final String name;
    private final ApplicationType type;
    private final String description;
    private final PasswordCredential passwordCredential;
    private final boolean permanent;
    private final boolean active;
    private final Map<String, String> attributes;
    private final List<DirectoryMapping> directoryMappings;
    private final Set<RemoteAddress> remoteAddresses;
    private final boolean lowercaseOutput;
    private final boolean aliasingEnabled;
    private final Date createdDate;
    private final Date updatedDate;

    public ImmutableApplication(Long id, String name, ApplicationType type, String description, PasswordCredential passwordCredential, boolean permanent, boolean active, Map<String, String> attributes, List<DirectoryMapping> directoryMappings, Set<RemoteAddress> remoteAddresses, boolean lowercaseOutput, boolean aliasingEnabled, Date createdDate, Date updatedDate) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.description = description;
        this.passwordCredential = passwordCredential;
        this.permanent = permanent;
        this.active = active;
        this.attributes = attributes == null ? Collections.emptyMap() : ImmutableMap.copyOf(attributes);
        this.directoryMappings = directoryMappings == null ? Collections.emptyList() : ImmutableList.copyOf(directoryMappings);
        this.remoteAddresses = remoteAddresses == null ? Collections.emptySet() : ImmutableSet.copyOf(remoteAddresses);
        this.lowercaseOutput = lowercaseOutput;
        this.aliasingEnabled = aliasingEnabled;
        this.createdDate = createdDate == null ? null : new Date(createdDate.getTime());
        this.updatedDate = updatedDate == null ? null : new Date(updatedDate.getTime());
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ApplicationType getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public PasswordCredential getCredential() {
        return this.passwordCredential;
    }

    public boolean isPermanent() {
        return this.permanent;
    }

    public boolean isActive() {
        return this.active;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<DirectoryMapping> getDirectoryMappings() {
        return this.directoryMappings;
    }

    public DirectoryMapping getDirectoryMapping(long directoryId) {
        Long dirId = directoryId;
        for (DirectoryMapping directoryMapping : this.directoryMappings) {
            if (!dirId.equals(directoryMapping.getDirectory().getId())) continue;
            return directoryMapping;
        }
        return null;
    }

    public Set<RemoteAddress> getRemoteAddresses() {
        return this.remoteAddresses;
    }

    public boolean hasRemoteAddress(String remoteAddress) {
        return this.remoteAddresses.contains(new RemoteAddress(remoteAddress));
    }

    public boolean isLowerCaseOutput() {
        return this.lowercaseOutput;
    }

    public boolean isAliasingEnabled() {
        return this.aliasingEnabled;
    }

    public Date getCreatedDate() {
        return this.createdDate == null ? null : new Date(this.createdDate.getTime());
    }

    public Date getUpdatedDate() {
        return this.updatedDate == null ? null : new Date(this.updatedDate.getTime());
    }

    public Set<String> getValues(String key) {
        String value = this.attributes.get(key);
        return value == null ? Collections.emptySet() : Collections.singleton(value);
    }

    public String getValue(String key) {
        return this.attributes.get(key);
    }

    public Set<String> getKeys() {
        return this.attributes.keySet();
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public static Builder builder(String name, ApplicationType type) {
        return new Builder(name, type);
    }

    public static Builder builder(Application application) {
        return new Builder(application);
    }

    public static class Builder {
        private Long id;
        private String name;
        private ApplicationType type;
        private String description;
        private PasswordCredential passwordCredential;
        private boolean permanent;
        private boolean active;
        private Map<String, String> attributes;
        private List<DirectoryMapping> directoryMappings;
        private Set<RemoteAddress> remoteAddresses;
        private boolean lowercaseOutput;
        private boolean aliasingEnabled;
        private Date createdDate;
        private Date updatedDate;

        public Builder(String name, ApplicationType type) {
            this.name = name;
            this.type = type;
        }

        public Builder(Application application) {
            this.id = application.getId();
            this.name = application.getName();
            this.type = application.getType();
            this.description = application.getDescription();
            this.passwordCredential = application.getCredential();
            this.permanent = application.isPermanent();
            this.active = application.isActive();
            this.attributes = application.getAttributes();
            this.directoryMappings = application.getDirectoryMappings();
            this.remoteAddresses = application.getRemoteAddresses();
            this.lowercaseOutput = application.isLowerCaseOutput();
            this.aliasingEnabled = application.isAliasingEnabled();
            this.createdDate = application.getCreatedDate();
            this.updatedDate = application.getUpdatedDate();
        }

        public Builder setId(Long id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setType(ApplicationType type) {
            this.type = type;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setPasswordCredential(PasswordCredential passwordCredential) {
            this.passwordCredential = passwordCredential;
            return this;
        }

        public Builder setPermanent(boolean permanent) {
            this.permanent = permanent;
            return this;
        }

        public Builder setActive(boolean active) {
            this.active = active;
            return this;
        }

        public Builder setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder setDirectoryMappings(List<DirectoryMapping> directoryMappings) {
            this.directoryMappings = directoryMappings;
            return this;
        }

        public Builder setRemoteAddresses(Set<RemoteAddress> remoteAddresses) {
            this.remoteAddresses = remoteAddresses;
            return this;
        }

        public Builder setLowercaseOutput(boolean lowercaseOutput) {
            this.lowercaseOutput = lowercaseOutput;
            return this;
        }

        public Builder setAliasingEnabled(boolean aliasingEnabled) {
            this.aliasingEnabled = aliasingEnabled;
            return this;
        }

        public Builder setCreatedDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public Builder setUpdatedDate(Date updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public ImmutableApplication build() {
            return new ImmutableApplication(this.id, this.name, this.type, this.description, this.passwordCredential, this.permanent, this.active, this.attributes, this.directoryMappings, this.remoteAddresses, this.lowercaseOutput, this.aliasingEnabled, this.createdDate, this.updatedDate);
        }
    }
}

