/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DirectoryMembershipsIterable
implements Iterable<Membership> {
    private final RemoteDirectory remoteDirectory;
    private final Iterable<String> groupNames;
    private final Function<String, Membership> lookUpMembers = new Function<String, Membership>(){

        public Membership apply(String from) {
            try {
                return DirectoryMembershipsIterable.this.get(from);
            }
            catch (OperationFailedException ofe) {
                throw new Membership.MembershipIterationException((Throwable)ofe);
            }
        }
    };
    public static final Function<Group, String> GROUPS_TO_NAMES = new Function<Group, String>(){

        public String apply(Group from) {
            return from.getName();
        }
    };

    public DirectoryMembershipsIterable(RemoteDirectory remoteDirectory, Iterable<String> groupNames) {
        Preconditions.checkNotNull((Object)remoteDirectory);
        Preconditions.checkNotNull(groupNames);
        this.remoteDirectory = remoteDirectory;
        this.groupNames = groupNames;
    }

    public DirectoryMembershipsIterable(RemoteDirectory remoteDirectory) throws OperationFailedException {
        Preconditions.checkNotNull((Object)remoteDirectory);
        List<Group> groups = remoteDirectory.searchGroups(QueryBuilder.queryFor(Group.class, EntityDescriptor.group(GroupType.GROUP)).returningAtMost(-1));
        this.remoteDirectory = remoteDirectory;
        this.groupNames = Iterables.transform(groups, GROUPS_TO_NAMES);
    }

    @Override
    public Iterator<Membership> iterator() {
        return Iterators.transform(this.groupNames.iterator(), this.lookUpMembers);
    }

    private Membership get(final String groupName) throws OperationFailedException {
        List<String> userNames = this.remoteDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
        List<String> childGroupNames = this.remoteDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(groupName).returningAtMost(-1));
        ImmutableSet userNamesSet = ImmutableSet.copyOf(userNames);
        ImmutableSet childGroupNamesSet = ImmutableSet.copyOf(childGroupNames);
        return new Membership((Set)userNamesSet, (Set)childGroupNamesSet){
            final /* synthetic */ Set val$userNamesSet;
            final /* synthetic */ Set val$childGroupNamesSet;
            {
                this.val$userNamesSet = set;
                this.val$childGroupNamesSet = set2;
            }

            public String getGroupName() {
                return groupName;
            }

            public Set<String> getUserNames() {
                return this.val$userNamesSet;
            }

            public Set<String> getChildGroupNames() {
                return this.val$childGroupNamesSet;
            }
        };
    }
}

