/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchResult<T> {
    private final List<T> successfulEntities;
    private final List<T> failedEntities;

    public BatchResult(int totalEntities) {
        this.successfulEntities = new ArrayList<T>(totalEntities);
        this.failedEntities = new ArrayList<T>();
    }

    public void addSuccess(T entity) {
        this.successfulEntities.add(entity);
    }

    public void addSuccesses(Collection<? extends T> entities) {
        this.successfulEntities.addAll(entities);
    }

    public void addFailure(T entity) {
        this.failedEntities.add(entity);
    }

    public void addFailures(Collection<? extends T> entities) {
        this.failedEntities.addAll(entities);
    }

    public boolean hasFailures() {
        return !this.failedEntities.isEmpty();
    }

    public int getTotalAttempted() {
        return this.successfulEntities.size() + this.failedEntities.size();
    }

    public List<T> getSuccessfulEntities() {
        return this.successfulEntities;
    }

    public List<T> getFailedEntities() {
        return this.failedEntities;
    }

    public int getTotalSuccessful() {
        return this.successfulEntities.size();
    }
}

