/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.search.query.entity;

import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.EntityDescriptor;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EntityQuery<T>
implements Query<T> {
    private final EntityDescriptor entityDescriptor;
    private final SearchRestriction searchRestriction;
    private final int startIndex;
    private final int maxResults;
    private Class<T> returnType;
    public static final int MAX_MAX_RESULTS = 1000;
    public static final int ALL_RESULTS = -1;

    public EntityQuery(Class<T> returnType, EntityDescriptor entityDescriptor, SearchRestriction searchRestriction, int startIndex, int maxResults) {
        Validate.notNull((Object)entityDescriptor, (String)"entity cannot be null");
        Validate.notNull((Object)searchRestriction, (String)"searchRestriction cannot be null");
        Validate.notNull(returnType, (String)"returnType cannot be null");
        Validate.isTrue((maxResults == -1 || maxResults > 0 ? 1 : 0) != 0, (String)"maxResults must be greater than 0 (unless set to EntityQuery.ALL_RESULTS)");
        Validate.isTrue((startIndex >= 0 ? 1 : 0) != 0, (String)"startIndex cannot be less than zero");
        this.entityDescriptor = entityDescriptor;
        this.searchRestriction = searchRestriction;
        this.startIndex = startIndex;
        this.maxResults = maxResults;
        this.returnType = returnType;
    }

    public EntityQuery(EntityQuery query, Class<T> returnType) {
        this(returnType, query.getEntityDescriptor(), query.getSearchRestriction(), query.getStartIndex(), query.getMaxResults());
    }

    public EntityQuery(EntityQuery<T> query, int startIndex, int maxResults) {
        this(query.getReturnType(), query.getEntityDescriptor(), query.getSearchRestriction(), startIndex, maxResults);
    }

    public EntityDescriptor getEntityDescriptor() {
        return this.entityDescriptor;
    }

    public SearchRestriction getSearchRestriction() {
        return this.searchRestriction;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public Class<T> getReturnType() {
        return this.returnType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityQuery)) {
            return false;
        }
        EntityQuery query = (EntityQuery)o;
        if (this.maxResults != query.maxResults) {
            return false;
        }
        if (this.startIndex != query.startIndex) {
            return false;
        }
        if (this.entityDescriptor != null ? !this.entityDescriptor.equals(query.entityDescriptor) : query.entityDescriptor != null) {
            return false;
        }
        if (this.returnType != query.returnType) {
            return false;
        }
        return !(this.searchRestriction != null ? !this.searchRestriction.equals(query.searchRestriction) : query.searchRestriction != null);
    }

    public int hashCode() {
        int result = this.entityDescriptor != null ? this.entityDescriptor.hashCode() : 0;
        result = 31 * result + (this.searchRestriction != null ? this.searchRestriction.hashCode() : 0);
        result = 31 * result + this.startIndex;
        result = 31 * result + this.maxResults;
        result = 31 * result + (this.returnType != null ? this.returnType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("entity", (Object)this.entityDescriptor).append("returnType", this.returnType).append("searchRestriction", (Object)this.searchRestriction).append("startIndex", this.startIndex).append("maxResults", this.maxResults).toString();
    }
}

