/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.model.user;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.model.InternalDirectoryEntity;
import com.atlassian.crowd.integration.model.InternalEntityTemplate;
import com.atlassian.crowd.integration.model.user.InternalUserCredentialRecord;
import com.atlassian.crowd.integration.model.user.User;
import com.atlassian.crowd.integration.model.user.UserTemplate;
import com.atlassian.crowd.integration.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.directory.Directory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalUser
extends InternalDirectoryEntity
implements User {
    private String emailAddress;
    private String firstName;
    private String lastName;
    private String displayName;
    private String iconLocation;
    private PasswordCredential credential;
    private String lowerName;
    private String lowerEmailAddress;
    private String lowerFirstName;
    private String lowerLastName;
    private String lowerDisplayName;
    private List<InternalUserCredentialRecord> credentialRecords = new ArrayList<InternalUserCredentialRecord>();

    protected InternalUser() {
    }

    public InternalUser(InternalEntityTemplate internalEntityTemplate, Directory directory, UserTemplate userTemplate, PasswordCredential credential) {
        super(internalEntityTemplate, directory);
        this.updateDetailsFrom(userTemplate);
        this.setCredential(credential);
    }

    public InternalUser(UserTemplateWithCredentialAndAttributes user, Directory directory) {
        this(user, directory, user.getCredential());
        if (user.getCreatedDate() != null) {
            this.createdDate = user.getCreatedDate();
        } else {
            this.setCreatedDateToNow();
        }
        if (user.getUpdatedDate() != null) {
            this.updatedDate = user.getUpdatedDate();
        } else {
            this.setUpdatedDateToNow();
        }
        for (PasswordCredential credential : user.getCredentialHistory()) {
            this.getCredentialRecords().add(new InternalUserCredentialRecord(this, credential.getCredential()));
        }
    }

    public InternalUser(User user, Directory directory, PasswordCredential credential) {
        Validate.notNull((Object)user, (String)"user argument cannot be null");
        Validate.notNull((Object)directory, (String)"directory argument cannot be null");
        InternalUser.validateCredential(credential);
        this.setName(user.getName());
        this.directory = directory;
        this.updateDetailsFrom(user);
        this.credential = credential;
    }

    private static void validateCredential(PasswordCredential credential) {
        if (credential != null) {
            Validate.notNull((Object)credential.getCredential(), (String)"credential argument cannot have null value");
            Validate.isTrue((boolean)credential.isEncryptedCredential(), (String)"credential must be encrypted");
        }
    }

    private void validateUser(User user) {
        Validate.notNull((Object)user, (String)"user argument cannot be null");
        Validate.notNull((Object)user.getDirectoryId(), (String)"user argument cannot have a null directoryId");
        Validate.notNull((Object)user.getName(), (String)"user argument cannot have a null name");
        Validate.notNull((Object)user.getEmailAddress(), (String)"user argument cannot have a null emailAddress");
        Validate.notNull((Object)user.getFirstName(), (String)"user argument cannot have a null firstName");
        Validate.notNull((Object)user.getLastName(), (String)"user argument cannot have a null lastName");
        Validate.isTrue((boolean)user.getDirectoryId().equals(this.getDirectoryId()), (String)"directoryId of updated user does not match the directoryId of the existing user.");
        Validate.isTrue((boolean)user.getName().equals(this.getName()), (String)"username of updated user does not match the username of the existing user.");
    }

    public void updateDetailsFrom(User user) {
        this.validateUser(user);
        this.active = user.isActive();
        this.emailAddress = user.getEmailAddress();
        this.lowerEmailAddress = this.emailAddress.toLowerCase();
        this.firstName = user.getFirstName();
        this.lowerFirstName = this.firstName.toLowerCase();
        this.lastName = user.getLastName();
        this.lowerLastName = this.lastName.toLowerCase();
        this.displayName = InternalUser.constructDisplayName(user);
        this.lowerDisplayName = this.displayName.toLowerCase();
        this.iconLocation = user.getIconLocation();
    }

    private static String constructDisplayName(User user) {
        if (user.getDisplayName() == null) {
            return user.getFirstName() + " " + user.getLastName();
        }
        return user.getDisplayName();
    }

    public void renameTo(String newUsername) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)newUsername), (String)"newUsername cannot be null or blank");
        this.setName(newUsername);
    }

    public void updateCredentialTo(PasswordCredential newCredential, int maxCredentialHistory) {
        InternalUser.validateCredential(newCredential);
        this.credential = newCredential;
        if (maxCredentialHistory > 0) {
            if (this.getCredentialRecords().size() > maxCredentialHistory - 1) {
                Iterator<InternalUserCredentialRecord> iterator = this.getCredentialRecords().iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    if (this.getCredentialRecords().size() <= maxCredentialHistory - 1) continue;
                    iterator.remove();
                }
            }
            InternalUserCredentialRecord record = new InternalUserCredentialRecord(this, newCredential.getCredential());
            this.getCredentialRecords().add(record);
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.lowerName = name.toLowerCase();
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIconLocation() {
        return this.iconLocation;
    }

    public String getLowerEmailAddress() {
        return this.lowerEmailAddress;
    }

    public String getLowerFirstName() {
        return this.lowerFirstName;
    }

    public String getLowerLastName() {
        return this.lowerLastName;
    }

    public String getLowerDisplayName() {
        return this.lowerDisplayName;
    }

    public String getLowerName() {
        return this.lowerName;
    }

    public PasswordCredential getCredential() {
        return this.credential;
    }

    public List<InternalUserCredentialRecord> getCredentialRecords() {
        return this.credentialRecords;
    }

    public List<PasswordCredential> getCredentialHistory() {
        ArrayList<PasswordCredential> credentials = new ArrayList<PasswordCredential>();
        for (InternalUserCredentialRecord record : this.getCredentialRecords()) {
            credentials.add(record.getCredential());
        }
        return credentials;
    }

    private void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    private void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    private void setLastName(String lastName) {
        this.lastName = lastName;
    }

    private void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    private void setIconLocation(String iconLocation) {
        this.iconLocation = iconLocation;
    }

    private void setCredential(PasswordCredential credential) {
        this.credential = credential;
    }

    private void setCredentialRecords(List<InternalUserCredentialRecord> credentialRecords) {
        this.credentialRecords = credentialRecords;
    }

    private void setLowerEmailAddress(String lowerEmailAddress) {
        this.lowerEmailAddress = lowerEmailAddress;
    }

    private void setLowerFirstName(String lowerFirstName) {
        this.lowerFirstName = lowerFirstName;
    }

    private void setLowerLastName(String lowerLastName) {
        this.lowerLastName = lowerLastName;
    }

    private void setLowerDisplayName(String lowerDisplayName) {
        this.lowerDisplayName = lowerDisplayName;
    }

    private void setLowerName(String lowerName) {
        this.lowerName = lowerName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalUser)) {
            return false;
        }
        InternalUser that = (InternalUser)o;
        if (this.getDirectoryId() != null ? !this.getDirectoryId().equals(that.getDirectoryId()) : that.getDirectoryId() != null) {
            return false;
        }
        return !(this.getLowerName() != null ? !this.getLowerName().equals(that.getLowerName()) : that.getLowerName() != null);
    }

    @Override
    public int hashCode() {
        int result = this.getLowerName() != null ? this.getLowerName().hashCode() : 0;
        result = 31 * result + (this.getDirectoryId() != null ? this.getDirectoryId().hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("name", (Object)this.getName()).append("createdDate", (Object)this.getCreatedDate()).append("updatedDate", (Object)this.getUpdatedDate()).append("active", this.isActive()).append("emailAddress", (Object)this.getEmailAddress()).append("firstName", (Object)this.getFirstName()).append("lastName", (Object)this.getLastName()).append("displayName", (Object)this.getDisplayName()).append("iconLocation", (Object)this.getIconLocation()).append("credential", (Object)this.getCredential()).append("lowerName", (Object)this.getLowerName()).append("lowerEmailAddress", (Object)this.getLowerEmailAddress()).append("lowerFirstName", (Object)this.getLowerFirstName()).append("lowerLastName", (Object)this.getLowerLastName()).append("lowerDisplayName", (Object)this.getLowerDisplayName()).append("directoryId", (Object)this.getDirectoryId()).toString();
    }
}

