/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.model.group;

import com.atlassian.crowd.integration.model.InternalDirectoryEntity;
import com.atlassian.crowd.integration.model.InternalEntityTemplate;
import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupTemplate;
import com.atlassian.crowd.integration.model.group.GroupType;
import com.atlassian.crowd.model.directory.Directory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class InternalGroup
extends InternalDirectoryEntity
implements Group {
    private String lowerName;
    private GroupType type;
    private String description;

    protected InternalGroup() {
    }

    public InternalGroup(InternalEntityTemplate internalEntityTemplate, Directory directory, GroupTemplate groupTemplate) {
        super(internalEntityTemplate, directory);
        this.type = groupTemplate.getType();
        this.updateDetailsFrom(groupTemplate);
    }

    public InternalGroup(Group group, Directory directory) {
        Validate.notNull((Object)directory, (String)"directory argument cannot be null");
        this.setName(group.getName());
        this.directory = directory;
        this.type = group.getType();
        this.updateDetailsFrom(group);
    }

    private void validateGroup(Group group) {
        Validate.notNull((Object)group, (String)"group argument cannot be null");
        Validate.notNull((Object)group.getDirectoryId(), (String)"group argument cannot have a null directoryID");
        Validate.notNull((Object)group.getName(), (String)"group argument cannot have a null name");
        Validate.notNull((Object)group.getType(), (String)"type argument cannot be null");
        Validate.isTrue((boolean)group.getDirectoryId().equals(this.getDirectoryId()), (String)"directoryID of updated group does not match the directoryID of the existing group.");
        Validate.isTrue((boolean)group.getName().equals(this.getName()), (String)"group name of updated group does not match the group name of the existing group.");
    }

    public void updateDetailsFrom(Group group) {
        this.validateGroup(group);
        this.active = group.isActive();
        this.description = group.getDescription();
    }

    public void renameTo(String newName) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)newName), (String)"the new name cannot be null or blank");
        this.setName(newName);
    }

    protected void setName(String name) {
        this.name = name;
        this.lowerName = name.toLowerCase();
    }

    public String getDescription() {
        return this.description;
    }

    public GroupType getType() {
        return this.type;
    }

    public String getLowerName() {
        return this.lowerName;
    }

    private void setLowerName(String lowerName) {
        this.lowerName = lowerName;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    private void setType(GroupType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalGroup)) {
            return false;
        }
        InternalGroup that = (InternalGroup)o;
        if (this.getDirectoryId() != null ? !this.getDirectoryId().equals(that.getDirectoryId()) : that.getDirectoryId() != null) {
            return false;
        }
        return !(this.getLowerName() != null ? !this.getLowerName().equals(that.getLowerName()) : that.getLowerName() != null);
    }

    public int hashCode() {
        int result = this.getLowerName() != null ? this.getLowerName().hashCode() : 0;
        result = 31 * result + (this.getDirectoryId() != null ? this.getDirectoryId().hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("name", (Object)this.getName()).append("type", (Object)this.getType()).append("active", this.isActive()).append("description", (Object)this.getDescription()).append("lowerName", (Object)this.getLowerName()).append("createdDate", (Object)this.getCreatedDate()).append("updatedDate", (Object)this.getUpdatedDate()).append("directoryId", (Object)this.getDirectoryId()).toString();
    }
}

