/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.model.group;

import com.atlassian.crowd.integration.model.group.Group;
import com.atlassian.crowd.integration.model.group.GroupType;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class GroupTemplate
implements Group,
Serializable {
    private String name;
    private Long directoryId;
    private GroupType type;
    private boolean active;
    private String description;

    public GroupTemplate(String name, Long directoryId, GroupType type) {
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)name), (String)"name argument cannot be null or blank");
        Validate.notNull((Object)type, (String)"type argument cannot be null");
        this.name = name;
        this.directoryId = directoryId;
        this.type = type;
        this.active = true;
    }

    public GroupTemplate(String name, GroupType type) {
        this(name, null, type);
    }

    public GroupTemplate(Group group) {
        Validate.notNull((Object)group, (String)"group argument cannot be null");
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)group.getName()), (String)"group.name argument cannot be null or blank");
        Validate.notNull((Object)group.getDirectoryId(), (String)"group.directoryId argument cannot be null");
        Validate.notNull((Object)group.getType(), (String)"group.type argument cannot be null");
        this.name = group.getName();
        this.directoryId = group.getDirectoryId();
        this.active = group.isActive();
        this.type = group.getType();
        this.description = group.getDescription();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDirectoryId(Long directoryId) {
        this.directoryId = directoryId;
    }

    public Long getDirectoryId() {
        return this.directoryId;
    }

    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GroupType getType() {
        return this.type;
    }

    public void setType(GroupType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GroupTemplate)) {
            return false;
        }
        GroupTemplate that = (GroupTemplate)o;
        if (this.directoryId != null ? !this.directoryId.equals(that.directoryId) : that.directoryId != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.directoryId != null ? this.directoryId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("directoryId", (Object)this.directoryId).append("active", this.active).append("type", (Object)this.type).append("description", (Object)this.description).toString();
    }
}

