/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.application;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.model.DirectoryEntity;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.GroupMapping;
import com.atlassian.crowd.model.application.RemoteAddress;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application
extends DirectoryEntity
implements Serializable {
    private static final String APPLICATION_TYPE = "applicationType";
    private static final String LOWER_CASE_OUTPUT = "lowerCaseOutput";
    private List<DirectoryMapping> directoryMappings;
    private List<GroupMapping> groupMappings;
    private List<RemoteAddress> addresses;
    private boolean perminant;
    protected List<PasswordCredential> credentials;
    public static final String ATLASSIAN_SHA1_APPLIED = "atlassian_sha1_applied";

    public List<DirectoryMapping> getDirectoryMappings() {
        if (this.directoryMappings == null) {
            this.directoryMappings = new ArrayList<DirectoryMapping>(0);
        }
        return this.directoryMappings;
    }

    public void setDirectoryMappings(List<DirectoryMapping> directoryMappings) {
        this.directoryMappings = directoryMappings;
    }

    public List<GroupMapping> getGroupMappings() {
        if (this.groupMappings == null) {
            this.groupMappings = new ArrayList<GroupMapping>(0);
        }
        return this.groupMappings;
    }

    public void setGroupMappings(List<GroupMapping> groupMappings) {
        this.groupMappings = groupMappings;
    }

    public List<RemoteAddress> getAddresses() {
        if (this.addresses == null) {
            this.addresses = new ArrayList<RemoteAddress>(0);
        }
        return this.addresses;
    }

    public void setAddresses(List<RemoteAddress> addresses) {
        this.addresses = addresses;
    }

    public boolean isPerminant() {
        return this.perminant;
    }

    public void setPerminant(boolean perminant) {
        this.perminant = perminant;
    }

    public List<PasswordCredential> getCredentials() {
        if (this.credentials == null) {
            this.credentials = new ArrayList<PasswordCredential>(0);
        }
        return this.credentials;
    }

    public void setCredentials(List<PasswordCredential> credentials) {
        this.credentials = credentials;
    }

    public ApplicationType getApplicationType() {
        ApplicationType type = null;
        String typeString = this.getSingleAttributeValue(APPLICATION_TYPE);
        if (typeString != null) {
            try {
                type = ApplicationType.valueOf(typeString);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (type == null) {
            type = ApplicationType.GENERIC_APPLICATION;
        }
        return type;
    }

    public String getApplicationTypeAsString() {
        return this.getApplicationType().name();
    }

    public void setApplicationType(ApplicationType type) {
        Assert.notNull((Object)((Object)type));
        this.setAttribute(APPLICATION_TYPE, type.name());
    }

    public boolean isLowerCaseOutput() {
        boolean flag = false;
        String value = this.getSingleAttributeValue(LOWER_CASE_OUTPUT);
        if (value != null) {
            flag = Boolean.parseBoolean(value);
        }
        return flag;
    }

    public void setLowerCaseOutput(boolean lowerCase) {
        this.setAttribute(LOWER_CASE_OUTPUT, Boolean.toString(lowerCase));
    }
}

