/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.soap;

import com.atlassian.crowd.integration.SearchContext;
import com.atlassian.crowd.integration.model.AttributeValues;
import com.atlassian.crowd.integration.model.DirectoryEntity;
import com.atlassian.crowd.integration.model.RemoteGroup;
import com.atlassian.crowd.integration.model.RemotePrincipal;
import com.atlassian.crowd.integration.model.RemoteRole;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPEntity;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPNestableGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SOAPRole;
import com.atlassian.crowd.integration.soap.SearchRestriction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTranslator {
    private static final Logger logger = Logger.getLogger(ObjectTranslator.class);

    public static SearchContext processRestrictions(SearchRestriction[] restrictions) {
        SearchContext searchContext = new SearchContext();
        if (restrictions != null) {
            for (int i = 0; i < restrictions.length; ++i) {
                SearchRestriction restriction = restrictions[i];
                if (restriction.getName() == null || restriction.getValue() == null || restriction.getName().length() <= 0 || restriction.getValue().length() <= 0) continue;
                if (restriction.getName().equals("group.populate.direct.sub.groups") || restriction.getName().equals("group.populate.memberships") || restriction.getName().equals("role.populate.memberships")) {
                    searchContext.put((Object)restriction.getName(), (Object)SearchContext.PopulateMemberships.parseString((String)restriction.getValue()));
                    continue;
                }
                searchContext.put((Object)restriction.getName(), (Object)restriction.getValue());
            }
        }
        return searchContext;
    }

    public static SOAPGroup[] processGroups(Collection groups, boolean forceLower) {
        SOAPGroup[] soapGroups = new SOAPGroup[groups.size()];
        Iterator groupIt = groups.iterator();
        for (int ctr = 0; ctr < soapGroups.length && groupIt.hasNext(); ++ctr) {
            soapGroups[ctr] = ObjectTranslator.processGroup((RemoteGroup)groupIt.next(), forceLower);
        }
        return soapGroups;
    }

    public static SOAPNestableGroup[] processNestableGroups(Collection groups, boolean forceLower) {
        SOAPNestableGroup[] soapGroups = new SOAPNestableGroup[groups.size()];
        Iterator groupIt = groups.iterator();
        for (int ctr = 0; ctr < soapGroups.length && groupIt.hasNext(); ++ctr) {
            soapGroups[ctr] = ObjectTranslator.processNestableGroup((RemoteGroup)groupIt.next(), forceLower);
        }
        return soapGroups;
    }

    public static SOAPPrincipal[] processPrincipals(Collection principals, boolean forceLower) {
        SOAPPrincipal[] soapPrincipals = new SOAPPrincipal[principals.size()];
        Iterator principalIt = principals.iterator();
        for (int ctr = 0; ctr < soapPrincipals.length && principalIt.hasNext(); ++ctr) {
            soapPrincipals[ctr] = ObjectTranslator.processPrincipal((RemotePrincipal)principalIt.next(), forceLower);
        }
        return soapPrincipals;
    }

    public static SOAPGroup processGroup(RemoteGroup remoteGroup, boolean forceLower) {
        SOAPGroup soapGroup = new SOAPGroup();
        ObjectTranslator.processDirectoryEntity(remoteGroup, (SOAPEntity)soapGroup, forceLower);
        ArrayList<String> memberNames = new ArrayList<String>();
        for (RemotePrincipal remotePrincipal : remoteGroup.getPrincipalMembers()) {
            String memberName = ObjectTranslator.processDirectoryEntityName(remotePrincipal.getName(), forceLower);
            memberNames.add(memberName);
        }
        soapGroup.setMembers(memberNames.toArray(new String[memberNames.size()]));
        return soapGroup;
    }

    public static SOAPNestableGroup processNestableGroup(RemoteGroup remoteGroup, boolean forceLower) {
        SOAPNestableGroup soapGroup = new SOAPNestableGroup();
        ObjectTranslator.processDirectoryEntity(remoteGroup, (SOAPEntity)soapGroup, forceLower);
        ArrayList<String> memberNames = new ArrayList<String>();
        for (RemoteGroup subGroup : remoteGroup.getContainerMembers()) {
            String memberName = ObjectTranslator.processDirectoryEntityName(subGroup.getName(), forceLower);
            memberNames.add(memberName);
        }
        soapGroup.setGroupMembers(memberNames.toArray(new String[memberNames.size()]));
        return soapGroup;
    }

    public static SOAPPrincipal processPrincipal(RemotePrincipal remotePrincipal, boolean forceLower) {
        SOAPPrincipal soapPrincipal = new SOAPPrincipal();
        ObjectTranslator.processDirectoryEntity(remotePrincipal, (SOAPEntity)soapPrincipal, forceLower);
        return soapPrincipal;
    }

    public static RemotePrincipal processPrincipal(SOAPPrincipal soapPrincipal) {
        RemotePrincipal remotePrincipal = new RemotePrincipal();
        ObjectTranslator.processSOAPEntity((SOAPEntity)soapPrincipal, remotePrincipal);
        return remotePrincipal;
    }

    public static SOAPRole[] processRoles(Collection roles, boolean forceLower) {
        SOAPRole[] soapRoles = new SOAPRole[roles.size()];
        Iterator roleIt = roles.iterator();
        for (int ctr = 0; ctr < soapRoles.length && roleIt.hasNext(); ++ctr) {
            soapRoles[ctr] = ObjectTranslator.processRole((RemoteRole)roleIt.next(), forceLower);
        }
        return soapRoles;
    }

    public static SOAPRole processRole(RemoteRole remoteRole, boolean forceLower) {
        SOAPRole soapRole = new SOAPRole();
        ObjectTranslator.processDirectoryEntity(remoteRole, (SOAPEntity)soapRole, forceLower);
        String[] memberNames = new String[remoteRole.getPrincipalMembers().size()];
        int ctr = 0;
        for (RemotePrincipal remotePrincipal : remoteRole.getPrincipalMembers()) {
            memberNames[ctr] = ObjectTranslator.processDirectoryEntityName(remotePrincipal.getName(), forceLower);
            ++ctr;
        }
        soapRole.setMembers(memberNames);
        return soapRole;
    }

    public static RemoteGroup processGroup(SOAPGroup soapGroup) {
        RemoteGroup remoteGroup = new RemoteGroup();
        ObjectTranslator.processSOAPEntity((SOAPEntity)soapGroup, remoteGroup);
        if (soapGroup.getMembers() != null) {
            HashSet<RemotePrincipal> principals = new HashSet<RemotePrincipal>(soapGroup.getMembers().length);
            String[] members = soapGroup.getMembers();
            for (int ctr = 0; ctr < members.length; ++ctr) {
                RemotePrincipal principal = new RemotePrincipal(members[ctr]);
                principals.add(principal);
            }
            remoteGroup.setPrincipalMembers(principals);
        }
        return remoteGroup;
    }

    public static RemoteRole processRole(SOAPRole soapRole) {
        RemoteRole remoteGroup = new RemoteRole();
        ObjectTranslator.processSOAPEntity((SOAPEntity)soapRole, remoteGroup);
        if (soapRole.getMembers() != null) {
            HashSet<RemotePrincipal> principals = new HashSet<RemotePrincipal>(soapRole.getMembers().length);
            String[] members = soapRole.getMembers();
            for (int ctr = 0; ctr < members.length; ++ctr) {
                RemotePrincipal principal = new RemotePrincipal(members[ctr]);
                principals.add(principal);
            }
            remoteGroup.setPrincipalMembers(principals);
        }
        return remoteGroup;
    }

    private static void processSOAPEntity(SOAPEntity soapEntity, DirectoryEntity directoryEntity) {
        directoryEntity.setActive(soapEntity.isActive());
        if (soapEntity.getAttributes() != null) {
            SOAPAttribute[] soapAttributes = soapEntity.getAttributes();
            for (int attributeCtr = 0; attributeCtr < soapAttributes.length; ++attributeCtr) {
                String[] soapValues;
                if (soapAttributes[attributeCtr] == null || (soapValues = soapAttributes[attributeCtr].getValues()) == null) continue;
                ArrayList<String> entityValues = new ArrayList<String>(soapValues.length);
                for (int valuesCtr = 0; valuesCtr < soapValues.length; ++valuesCtr) {
                    entityValues.add(soapValues[valuesCtr]);
                }
                directoryEntity.setOrReplaceAttribute(soapAttributes[attributeCtr].getName(), entityValues);
            }
        }
        directoryEntity.setConception(soapEntity.getConception());
        directoryEntity.setDescription(soapEntity.getDescription());
        directoryEntity.setDirectoryID(soapEntity.getDirectoryID());
        directoryEntity.setLastModified(soapEntity.getLastModified());
        directoryEntity.setName(soapEntity.getName());
    }

    private static void processDirectoryEntity(DirectoryEntity directoryEntity, SOAPEntity soapEntity, boolean forceLower) {
        soapEntity.setActive(directoryEntity.isActive());
        Map<String, AttributeValues> attributes = directoryEntity.getAttributes();
        Set<String> keys = attributes.keySet();
        SOAPAttribute[] soapAttributes = new SOAPAttribute[keys.size()];
        int ctr = 0;
        for (String key : keys) {
            AttributeValues values = attributes.get(key);
            soapAttributes[ctr] = new SOAPAttribute();
            soapAttributes[ctr].setName(key);
            soapAttributes[ctr].setValues(values.getValues().toArray(new String[values.getValues().size()]));
            ++ctr;
        }
        soapEntity.setAttributes(soapAttributes);
        soapEntity.setConception(directoryEntity.getConception());
        soapEntity.setDescription(directoryEntity.getDescription());
        soapEntity.setDirectoryID(directoryEntity.getDirectoryID());
        soapEntity.setID(directoryEntity.getID());
        soapEntity.setLastModified(directoryEntity.getLastModified());
        soapEntity.setName(ObjectTranslator.processDirectoryEntityName(directoryEntity.getName(), forceLower));
    }

    public static AttributeValues processValues(SOAPAttribute attribbute) {
        AttributeValues values = new AttributeValues();
        if (attribbute != null) {
            values.setValues(Arrays.asList(attribbute.getValues()));
        }
        return values;
    }

    public static String processDirectoryEntityName(String name, boolean forceLower) {
        if (forceLower) {
            return name.toLowerCase();
        }
        return name;
    }

    public static List<String> processDirectoryEntityNames(Collection<String> names, boolean forceLower) {
        ArrayList<String> newNames = new ArrayList<String>(names.size());
        for (String name : names) {
            newNames.add(ObjectTranslator.processDirectoryEntityName(name, forceLower));
        }
        return newNames;
    }
}

