/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.model;

import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.model.AttributeValues;
import com.atlassian.crowd.integration.model.DirectoryEntity;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotePrincipal
extends DirectoryEntity
implements Principal,
Serializable {
    public static final String USERNAME = "username";
    public static final String FIRSTNAME = "givenName";
    public static final String LASTNAME = "sn";
    public static final String DISPLAYNAME = "displayName";
    public static final String EMAIL = "mail";
    public static final String PASSWORD_LASTCHANGED = "passwordLastChanged";
    public static final String LAST_AUTHENTICATED = "lastAuthenticated";
    public static final String INVALID_PASSWORD_ATTEMPTS = "invalidPasswordAttempts";
    public static final String REQUIRES_PASSSWORD_CHANGE = "requiresPasswordChange";
    protected List<PasswordCredential> credentials;
    protected List<PasswordCredential> credentialHistory;

    public RemotePrincipal() {
    }

    public RemotePrincipal(String name) {
        this();
        this.setName(name);
    }

    public RemotePrincipal(RemotePrincipal principal) {
        super(principal);
        this.setCredentials(this.cloneCredentials(principal.getCredentials()));
        this.setCredentialHistory(this.cloneCredentials(principal.getCredentialHistory()));
    }

    private List<PasswordCredential> cloneCredentials(List<PasswordCredential> credentials) {
        ArrayList<PasswordCredential> newCredentials = null;
        if (!credentials.isEmpty()) {
            newCredentials = new ArrayList<PasswordCredential>();
            for (PasswordCredential credential : credentials) {
                if (credential == null) continue;
                PasswordCredential passwordCredentialClone = new PasswordCredential(credential);
                if (credential.isEncryptedCredential()) {
                    passwordCredentialClone.setEncryptedCredential(true);
                } else {
                    passwordCredentialClone.setEncryptedCredential(false);
                }
                newCredentials.add(passwordCredentialClone);
            }
        }
        return newCredentials;
    }

    public String getEmail() {
        AttributeValues attributeValues = this.getAttribute(EMAIL);
        if (attributeValues.getSingleValue() != null) {
            return attributeValues.getSingleValue();
        }
        return "";
    }

    public void setEmail(String email) {
        this.setAttribute(EMAIL, email);
    }

    public List<PasswordCredential> getCredentials() {
        if (this.credentials == null) {
            this.credentials = new ArrayList<PasswordCredential>();
        }
        return this.credentials;
    }

    public void setCredentials(List<PasswordCredential> credentials) {
        this.credentials = credentials;
    }

    public List<PasswordCredential> getCredentialHistory() {
        if (this.credentialHistory == null) {
            this.credentialHistory = new ArrayList<PasswordCredential>();
        }
        return this.credentialHistory;
    }

    public void setCredentialHistory(List<PasswordCredential> credentialHistory) {
        this.credentialHistory = credentialHistory;
    }
}

