/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.console.action;

import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.crowd.integration.exception.InvalidPrincipalException;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetailsService;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.bootstrap.CrowdBootstrapManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.license.CrowdLicenseManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.permission.ApplicationDirectoryPermissionDAO;
import com.atlassian.crowd.model.permission.PermissionType;
import com.atlassian.extras.api.crowd.CrowdLicense;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.model.WebLink;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.ActionSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;

public class BaseAction
extends ActionSupport {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    protected Integer tab = 1;
    private Boolean authenticated = null;
    private Boolean admin = null;
    private SOAPPrincipal remotePrincipal;
    protected boolean initialLoad = true;
    private Map siteMeshProperties = null;
    protected String actionMessageAlertColor;
    public static final String ALERT_GREEN = "green";
    public static final String ALERT_YELLOW = "yellow";
    public static final String ALERT_RED = "red";
    public static final String ALERT_BLUE = "blue";
    protected PropertyManager propertyManager;
    protected DirectoryManager directoryManager;
    protected ApplicationManager applicationManager;
    protected CrowdLicenseManager crowdLicenseManager;
    private ApplicationDirectoryPermissionDAO applicationDirectoryPermissionDAO;
    private CrowdUserDetailsService crowdUserDetailsService;
    private Map webFragmentsContextMap;
    private WebInterfaceManager webInterfaceManager;
    private Integer currentLicenseResourceTotal = new Integer(0);
    private static final String DEFAULT_IMAGE_LOCATION = "/console/images/icons/16x16/16";
    private static final String ICON_IMAGE_TYPE = ".png";

    public String doDefault() throws Exception {
        return "success";
    }

    protected void updateAuthenticationStatus() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        this.admin = false;
        if (auth == null || auth instanceof AnonymousAuthenticationToken || auth.getPrincipal() == null || !(auth.getPrincipal() instanceof CrowdUserDetails)) {
            this.authenticated = false;
            this.remotePrincipal = null;
        } else {
            this.authenticated = true;
            CrowdUserDetails userDetails = (CrowdUserDetails)auth.getPrincipal();
            this.remotePrincipal = userDetails.getRemotePrincipal();
            String adminRole = this.crowdUserDetailsService.getAuthorityPrefix() + this.crowdUserDetailsService.getAuthoritySuffix();
            for (int i = 0; i < userDetails.getAuthorities().length; ++i) {
                if (!userDetails.getAuthorities()[i].getAuthority().equals(adminRole)) continue;
                this.admin = true;
                break;
            }
        }
    }

    public boolean isAuthenticated() {
        if (this.isSetupComplete() && this.authenticated == null) {
            this.updateAuthenticationStatus();
        } else if (!this.isSetupComplete()) {
            this.authenticated = Boolean.FALSE;
        }
        return this.authenticated;
    }

    public boolean isAdmin() {
        if (!this.isAuthenticated()) {
            this.admin = false;
        } else if (this.admin == null) {
            this.updateAuthenticationStatus();
        }
        return this.admin;
    }

    public String getSitemeshPageProperty(String propertyName) {
        String property = null;
        Map properties = this.getSitemeshPageProperties();
        if (properties != null) {
            property = (String)properties.get(propertyName);
        }
        return property;
    }

    public Map getSitemeshPageProperties() {
        Page page;
        if (this.siteMeshProperties == null && (page = (Page)ServletActionContext.getPageContext().getAttribute("sitemeshPage")) != null) {
            this.siteMeshProperties = page.getProperties();
        }
        return this.siteMeshProperties;
    }

    public String getPrincipalName() throws InvalidPrincipalException {
        if (!this.isAuthenticated()) {
            return null;
        }
        String principalName = "";
        if (this.getRemotePrincipal() != null) {
            String firstName = this.getFirstAttribute("givenName");
            String lastName = this.getFirstAttribute("sn");
            if (TextUtils.stringSet((String)firstName)) {
                principalName = firstName;
            }
            if (TextUtils.stringSet((String)lastName)) {
                if (TextUtils.stringSet((String)principalName) && principalName.length() > 0) {
                    principalName = principalName + " ";
                }
                principalName = principalName + lastName;
            }
            if (!TextUtils.stringSet((String)principalName)) {
                principalName = this.getRemotePrincipal().getName();
            }
        }
        return principalName;
    }

    public SOAPPrincipal getRemotePrincipal() {
        if (!this.isAuthenticated()) {
            return null;
        }
        if (this.remotePrincipal == null) {
            this.updateAuthenticationStatus();
        }
        return this.remotePrincipal;
    }

    public SOAPAttribute getAttribute(String name) throws InvalidPrincipalException {
        if (!this.isAuthenticated()) {
            return null;
        }
        SOAPPrincipal remotePrincipal = this.getRemotePrincipal();
        SOAPAttribute[] attributes = remotePrincipal.getAttributes();
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equals(name)) continue;
            return attributes[i];
        }
        SOAPAttribute soapAttribute = new SOAPAttribute();
        soapAttribute.setName(name);
        return soapAttribute;
    }

    public String getFirstAttribute(String name) throws InvalidPrincipalException {
        SOAPAttribute attribute = this.getAttribute(name);
        if (attribute == null || attribute.getValues() == null) {
            return null;
        }
        if (attribute.getValues().length > 0) {
            return attribute.getValues()[0];
        }
        return null;
    }

    protected HttpSession getSession() {
        return ServletActionContext.getRequest().getSession();
    }

    protected HttpServletRequest getHttpRequest() {
        return ServletActionContext.getRequest();
    }

    public Integer getTab() {
        return this.tab;
    }

    public void setTab(Integer tab) {
        this.tab = tab;
    }

    public Directory directory(long directoryID) {
        try {
            return this.directoryManager.findDirectoryByID(directoryID);
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage(), (Throwable)e);
            this.addActionError(e.getMessage());
            return null;
        }
    }

    public boolean isInitialLoad() {
        return this.initialLoad;
    }

    public CrowdLicense getLicense() {
        return this.crowdLicenseManager.getLicense();
    }

    public boolean isEvaluation() {
        return this.isSetupComplete() && this.getLicense().isEvaluation();
    }

    private boolean isSetupComplete() {
        return this.getBootstrapManager().isSetupComplete();
    }

    public boolean isLicenseExpired() {
        return this.isSetupComplete() && this.getLicense().isExpired();
    }

    public String getActionMessageAlertColor() {
        if (StringUtils.isEmpty((String)this.actionMessageAlertColor)) {
            return ALERT_YELLOW;
        }
        return this.actionMessageAlertColor;
    }

    public void addActionMessage(String color, String message) {
        this.actionMessageAlertColor = color;
        this.addActionMessage(message);
    }

    protected void assignDefaultApplicationPermissions(DirectoryMapping directoryMapping) {
        List permissionTypes = PermissionType.getPermissionTypes();
        for (PermissionType permissionType : permissionTypes) {
            this.applicationDirectoryPermissionDAO.addPermission(directoryMapping.getApplication(), directoryMapping.getDirectory(), permissionType);
        }
    }

    public List getWebItemsForSection(String sectionName) {
        return this.webInterfaceManager.getDisplayableItems(sectionName, this.getWebFragmentsContextMap());
    }

    public List getWebSectionsForLocation(String location) {
        return this.webInterfaceManager.getDisplayableSections(location, this.getWebFragmentsContextMap());
    }

    public String renderFreemarkerTemplate(String templateString) {
        return this.webInterfaceManager.getWebFragmentHelper().renderVelocityFragment(templateString, this.getWebFragmentsContextMap());
    }

    public Map getWebFragmentsContextMap() {
        if (this.webFragmentsContextMap == null) {
            Map map = (Map)ServletActionContext.getContext().get((Object)"com.opensymphony.xwork.ActionContext.parameters");
            this.webFragmentsContextMap = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof String[]) {
                    String[] strArray = (String[])value;
                    this.webFragmentsContextMap.put(key, strArray[0]);
                    continue;
                }
                this.webFragmentsContextMap.put(key, value);
            }
            this.webFragmentsContextMap.putAll(this.getSitemeshPageProperties());
        }
        return this.webFragmentsContextMap;
    }

    public String getDisplayableLink(WebLink link) {
        return link.getDisplayableUrl(this.getHttpRequest(), this.getWebFragmentsContextMap());
    }

    public String getLink(WebLink link) {
        return link.getDisplayableUrl(this.getHttpRequest(), Collections.EMPTY_MAP);
    }

    public boolean containsErrorMessages() {
        return this.getActionErrors() != null && !this.getActionErrors().isEmpty();
    }

    public boolean containsActionMessages() {
        return this.getActionMessages() != null && !this.getActionMessages().isEmpty();
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    public void setCrowdLicenseManager(CrowdLicenseManager crowdLicenseManager) {
        this.crowdLicenseManager = crowdLicenseManager;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setApplicationDirectoryPermissionDAO(ApplicationDirectoryPermissionDAO applicationDirectoryPermissionDAO) {
        this.applicationDirectoryPermissionDAO = applicationDirectoryPermissionDAO;
    }

    public void setCrowdUserDetailsService(CrowdUserDetailsService crowdUserDetailsService) {
        this.crowdUserDetailsService = crowdUserDetailsService;
    }

    public void setWebInterfaceManager(WebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public WebInterfaceManager getWebInterfaceManager() {
        return this.webInterfaceManager;
    }

    protected CrowdBootstrapManager getBootstrapManager() {
        return (CrowdBootstrapManager)BootstrapUtils.getBootstrapManager();
    }

    public boolean isAtResourceLimit() {
        return this.crowdLicenseManager.isResourceTotalOverLimit(90.0f, this.getCurrentLicenseResourceTotal());
    }

    public Integer getCurrentLicenseResourceTotal() {
        if (this.currentLicenseResourceTotal == null || this.currentLicenseResourceTotal == 0) {
            this.currentLicenseResourceTotal = new Integer(this.propertyManager.getCurrentLicenseResourceTotal());
        }
        return this.currentLicenseResourceTotal;
    }

    public String getImageTitle(boolean active, ApplicationType applicationType) {
        String imageI8n = "application." + applicationType.toString().toLowerCase() + (active ? ".enabled" : ".disabled");
        return this.getText(imageI8n);
    }

    public String getImageLocation(boolean active, ApplicationType applicationType) {
        return ServletActionContext.getRequest().getContextPath() + DEFAULT_IMAGE_LOCATION + applicationType.toString().toLowerCase() + (active ? "" : "_disabled") + ICON_IMAGE_TYPE;
    }
}

