/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtils {
    private static final Logger log = LoggerFactory.getLogger(PropertyUtils.class);

    public static Properties getProperties(String resource, Class<?> callingClass) {
        InputStream is = callingClass.getResourceAsStream("/" + resource);
        if (is == null) {
            return null;
        }
        return PropertyUtils.getPropertiesFromStream(is);
    }

    public static Properties getPropertiesFromFile(File file) {
        try {
            return PropertyUtils.getPropertiesFromStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            log.error("Error loading properties from file: " + file.getPath() + ". File does not exist.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPropertiesFromStream(@Nonnull InputStream is) {
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
            log.error("Error loading properties from stream.", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return props;
    }
}

