/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.utils;

import com.atlassian.crowd.acceptance.utils.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ActionWorker
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Action action;
    private final int iterations;
    private int failures;

    public ActionWorker(Action action, int iterations) {
        this.action = action;
        this.iterations = iterations;
        this.failures = 0;
    }

    @Override
    public void run() {
        for (int i = 0; i < this.iterations; ++i) {
            this.logger.info("Running iteration: " + i);
            try {
                this.action.execute();
                continue;
            }
            catch (Exception e) {
                this.logger.warn("Failed to execute action test", (Throwable)e);
                ++this.failures;
            }
        }
    }

    public int getFailures() {
        return this.failures;
    }
}

