/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.utils;

import com.atlassian.crowd.acceptance.utils.Action;
import com.atlassian.crowd.acceptance.utils.ActionWorker;
import java.util.ArrayList;

public class ActionRunner
implements Action {
    private final int threads;
    private final int iterations;
    private final Action action;
    private int failures;

    public ActionRunner(int threads, int iterations, Action action) {
        this.threads = threads;
        this.iterations = iterations;
        this.action = action;
        this.failures = 0;
    }

    @Override
    public void execute() {
        ArrayList<ActionWorker> workers = new ArrayList<ActionWorker>(this.threads);
        ArrayList<Thread> executions = new ArrayList<Thread>(this.threads);
        for (int i = 0; i < this.threads; ++i) {
            ActionWorker worker = new ActionWorker(this.action, this.iterations);
            workers.add(worker);
            Thread execution = new Thread(worker);
            executions.add(execution);
            execution.start();
        }
        for (Thread execution : executions) {
            try {
                execution.join();
            }
            catch (InterruptedException e) {
                break;
            }
        }
        for (ActionWorker worker : workers) {
            this.failures += worker.getFailures();
        }
    }

    public int getFailures() {
        return this.failures;
    }
}

