/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.utils;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.DbCachingTestHelper;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.directory.OpenLDAP;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Properties;
import junit.framework.AssertionFailedError;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public abstract class AbstractDbCachingLoadTest
extends CrowdAcceptanceTestCase {
    private static final String PROPERTY_FILE = System.getProperty("tpm.loadtest.file", "crowd-ad1-loadtest10k.properties");
    private static final Properties SERVER_PROPERTIES = DirectoryTestHelper.getConfigProperties(PROPERTY_FILE);
    public static final String CHILD_OU_A = SERVER_PROPERTIES.getProperty("test.directory.childOUA");
    public static final String CHILD_OU_B = SERVER_PROPERTIES.getProperty("test.directory.childOUB");
    public static final String CHILD_OU_C = SERVER_PROPERTIES.getProperty("test.directory.childOUC");
    public static final String CHILD_OU_D = SERVER_PROPERTIES.getProperty("test.directory.childOUD");
    public static final String CONNECTOR_BASEDN = SERVER_PROPERTIES.getProperty("test.directory.basedn");
    public static final String CONNECTOR_URL = SERVER_PROPERTIES.getProperty("test.directory.url");
    public static final String CONNECTOR_SECURE = SERVER_PROPERTIES.getProperty("test.directory.secure");
    public static final String CONNECTOR_REFERRAL = SERVER_PROPERTIES.getProperty("test.directory.referral");
    public static final String CONNECTOR_PAGEDRESULTS = SERVER_PROPERTIES.getProperty("test.directory.pagedresults.use");
    public static final String CONNECTOR_PAGEDRESULTSSIZE = SERVER_PROPERTIES.getProperty("test.directory.pagedresults.size");
    public static final String CONNECTOR_USERDN = SERVER_PROPERTIES.getProperty("test.directory.userdn");
    public static final String CONNECTOR_USERPW = SERVER_PROPERTIES.getProperty("test.directory.password");
    public static final String CONNECTOR_CLASSNAME = SERVER_PROPERTIES.getProperty("test.directory.classname");
    public static final String CONNECTOR_NESTEDGROUPS = SERVER_PROPERTIES.getProperty("test.directory.nested.groups.disabled");
    public static final String CONNECTOR_DIRECTORY_NAME = "Test Connector Directory";
    public static final int ONE_MINUTE_IN_MILLIS = 60000;
    public static final String PARTIAL_GROUPNAME = SERVER_PROPERTIES.getProperty("test.directory.group.name");
    public static final String PARTIAL_USERNAME = SERVER_PROPERTIES.getProperty("test.directory.user.name");
    public static final int MEMBERSHIPS_COUNT = NumberUtils.toInt((String)SERVER_PROPERTIES.getProperty("test.directory.membership.size"));
    private DbCachingTestHelper dbCachingTestHelper;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.dbCachingTestHelper = new DbCachingTestHelper(this.tester);
    }

    public long synchroniseDirectory(String shortDescription) throws InterruptedException {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME);
        if (!this.isSynchronising()) {
            this.clickButton("synchroniseDirectoryButton");
        }
        this.waitForExistingSyncToFinish();
        String syncDuration = this.getElementTextById("duration");
        this.logger.info("Synchronisation took: " + syncDuration + " (" + shortDescription + ")");
        return AbstractDbCachingLoadTest.parsePrettyDurationToSeconds(syncDuration);
    }

    protected static long parsePrettyDurationToSeconds(String duration) {
        String[] components;
        if (StringUtils.isBlank((CharSequence)duration)) {
            return 0L;
        }
        long seconds = 0L;
        for (String component : components = StringUtils.split((String)duration, (char)',')) {
            component = component.trim();
            String[] parts = StringUtils.split((String)component, (char)' ');
            long quantity = Long.parseLong(parts[0]);
            if (parts[1].startsWith("second")) {
                seconds += quantity;
                continue;
            }
            if (parts[1].startsWith("minute")) {
                seconds += 60L * quantity;
                continue;
            }
            if (parts[1].startsWith("hour")) {
                seconds += 3600L * quantity;
                continue;
            }
            if (parts[1].startsWith("day")) {
                seconds += 86400L * quantity;
                continue;
            }
            throw new IllegalArgumentException("unsupported time unit:" + parts[1]);
        }
        return seconds;
    }

    public void waitForExistingSyncToFinish() throws InterruptedException {
        this.gotoBrowseDirectories();
        Thread.sleep(10000L);
        this.clickLinkWithExactText(CONNECTOR_DIRECTORY_NAME);
        this.logger.info("Waiting for an existing sync to finish");
        while (this.isSynchronising()) {
            Thread.sleep(30000L);
        }
        this.logger.info("Existing sync should have finished, proceed with tests.");
    }

    public void createLoadTestingDirectory(String url, String baseDN, String userDN, String password) {
        this.gotoCreateDirectory();
        this.setRadioButton("directoryType", DirectoryType.CONNECTOR.name());
        this.submit();
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", CONNECTOR_DIRECTORY_NAME);
        this.setTextField("description", "");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", this.getConnectorType());
        if (Boolean.parseBoolean(CONNECTOR_SECURE)) {
            this.checkCheckbox("secure");
        }
        this.setTextField("URL", url);
        this.setTextField("baseDN", baseDN);
        this.setTextField("userDN", userDN);
        this.setTextField("readTimeoutInSec", "0");
        this.setTextField("searchTimeoutInSec", "0");
        this.setTextField("pollingIntervalInMin", "10000000000000");
        this.setTextField("ldapPassword", password);
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", (List)ImmutableList.of((Object)CONNECTOR_DIRECTORY_NAME));
        this.setWorkingForm("updateGeneral");
        this.assertTextFieldEquals("name", CONNECTOR_DIRECTORY_NAME);
        this.assertTextFieldEquals("directoryDescription", "");
        this.assertTextPresent(this.getConnectorType());
        this.clickLink("connector-connectiondetails");
        this.assertTextFieldEquals("URL", url);
        this.assertTextFieldEquals("baseDN", baseDN);
        this.assertTextFieldEquals("userDN", userDN);
    }

    protected boolean isSynchronising() {
        return this.dbCachingTestHelper.isSynchronising();
    }

    protected String getConnectorType() {
        if (CONNECTOR_CLASSNAME.equals(MicrosoftActiveDirectory.class.getName())) {
            return MicrosoftActiveDirectory.getStaticDirectoryType();
        }
        if (CONNECTOR_CLASSNAME.equals(OpenLDAP.class.getName())) {
            return OpenLDAP.getStaticDirectoryType();
        }
        throw new AssertionFailedError("Invalid connector type provided in properties file. Could not select appropriate connector type.");
    }

    public void assertUsersAndGroupsFromOUPresent(String childOU) {
        this.searchUsers(childOU);
        this.assertTextPresent(this.createUserName(childOU, 0));
        this.assertTextPresent(this.createUserName(childOU, 1));
        this.assertTextPresent(this.createUserName(childOU, 10));
        this.searchGroups(childOU);
        this.assertTextPresent(this.createGroupName(childOU, 0));
        this.assertTextPresent(this.createGroupName(childOU, 1));
        this.assertTextPresent(this.createGroupName(childOU, 10));
    }

    public void assertUsersAndGroupsFromOUNotPresent(String childOU) {
        this.searchUsers(childOU);
        this.assertTextNotPresent(this.createUserName(childOU, 0));
        this.assertTextNotPresent(this.createUserName(childOU, 1));
        this.assertTextNotPresent(this.createUserName(childOU, 10));
        this.searchGroups(childOU);
        this.assertTextNotPresent(this.createGroupName(childOU, 0));
        this.assertTextNotPresent(this.createGroupName(childOU, 1));
        this.assertTextNotPresent(this.createGroupName(childOU, 10));
    }

    private void searchGroups(String childOU) {
        this.gotoBrowseGroups();
        this.setWorkingForm("browsegroups");
        this.setTextField("name", childOU + "-group");
        this.selectOption("directoryID", CONNECTOR_DIRECTORY_NAME);
        this.submit();
    }

    private void searchUsers(String childOU) {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.setTextField("search", childOU + "Test");
        this.selectOption("directoryID", CONNECTOR_DIRECTORY_NAME);
        this.submit();
    }

    public String createUserName(String childOU, int index) {
        return childOU + PARTIAL_USERNAME + index;
    }

    public String createGroupName(String childOU, int index) {
        return childOU + PARTIAL_GROUPNAME + index;
    }
}

