/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.soap;

import com.google.common.collect.ComparisonChain;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WsdlNormalizer {
    static Document parseAndNormalize(String documentText) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(documentText)));
        Element root = doc.getDocumentElement();
        WsdlNormalizer.sortChildren(root);
        WsdlNormalizer.setTypesToExpandedForm(root);
        return doc;
    }

    private static void setTypesToExpandedForm(Element parent) {
        String prefix;
        String uri;
        String type = parent.getAttribute("type");
        int i = type.indexOf(58);
        if (i >= 0 && (uri = parent.lookupNamespaceURI(prefix = type.substring(0, i))) != null) {
            type = "{" + uri + "}" + type.substring(i);
            parent.setAttribute("type", type);
        }
        for (Node n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!(n instanceof Element)) continue;
            WsdlNormalizer.setTypesToExpandedForm((Element)n);
        }
    }

    private static void sortChildren(Element parent) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Node n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!(n instanceof Element)) continue;
            elements.add((Element)n);
        }
        for (Element e : elements) {
            parent.removeChild(e);
        }
        Collections.sort(elements, new WsdlElementComparator());
        for (Element e : elements) {
            parent.appendChild(e);
            if (!e.getTagName().equals("wsdl:portType") && !e.getTagName().equals("xsd:schema") && !e.getTagName().equals("wsdl:types") && !e.getTagName().equals("wsdl:operation") && !e.getTagName().equals("wsdl:binding")) continue;
            WsdlNormalizer.sortChildren(e);
        }
    }

    private static class WsdlElementComparator
    implements Comparator<Element> {
        private WsdlElementComparator() {
        }

        @Override
        public int compare(Element o1, Element o2) {
            return ComparisonChain.start().compare((Comparable)((Object)o1.getTagName()), (Comparable)((Object)o2.getTagName())).compare((Comparable)((Object)o1.getAttribute("name")), (Comparable)((Object)o2.getAttribute("name"))).compare((Comparable)((Object)o1.getAttribute("targetNamespace")), (Comparable)((Object)o2.getAttribute("targetNamespace"))).result();
        }
    }
}

