/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.soap;

import com.atlassian.crowd.acceptance.tests.soap.InformationLeakingTestBase;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class SoapXmlParsingTest
extends InformationLeakingTestBase {
    HttpResponse postToSoapEndpoint(String content, String pathSuffix) throws HttpException, IOException {
        String endpoint = this.getBaseUrl() + "/services" + pathSuffix;
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost m = new HttpPost(endpoint);
        m.setEntity((HttpEntity)new StringEntity(content, ContentType.create((String)"application/soap+xml", (String)"us-ascii")));
        return client.execute((HttpUriRequest)m);
    }

    HttpResponse postToSoapEndpoint(String content) throws HttpException, IOException {
        return this.postToSoapEndpoint(content, "");
    }

    public void testEntityExpansionDoesNotIncludeFileContents() throws HttpException, IOException {
        this.runEntityExpansionTestWithPathSuffix("");
    }

    private void runEntityExpansionTestWithPathSuffix(String pathSuffix) throws HttpException, IOException {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("SoapXmlParsingTest-soap-include-external-entity.xml");
        SoapXmlParsingTest.assertNotNull((Object)in);
        String contents = IOUtils.toString((InputStream)in, (String)"us-ascii");
        contents = contents.replace("/etc/passwd", this.createSecretFile().toURI().toString());
        HttpResponse m = this.postToSoapEndpoint(contents, pathSuffix);
        MediaType mt = MediaType.valueOf((String)m.getFirstHeader("content-type").getValue());
        Assert.assertThat((String)"The response should be XML", (Object)(mt.getType() + '/' + mt.getSubtype()), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.is((Object)"text/xml"), (Matcher)CoreMatchers.is((Object)"application/xml"), (Matcher)CoreMatchers.is((Object)"application/soap+xml")));
        String resp = EntityUtils.toString((HttpEntity)m.getEntity(), (String)"us-ascii");
        Assert.assertThat((Object)resp, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)this.secret)));
    }

    public void testValidEntitiesAreExpanded() throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("SoapXmlParsingTest-soap-with-amp-entity.xml");
        SoapXmlParsingTest.assertNotNull((Object)in);
        String contents = IOUtils.toString((InputStream)in, (String)"us-ascii");
        HttpResponse m = this.postToSoapEndpoint(contents);
        MediaType mt = MediaType.valueOf((String)m.getFirstHeader("content-type").getValue());
        Assert.assertThat((String)"The response should be XML", (Object)(mt.getType() + '/' + mt.getSubtype()), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.is((Object)"text/xml"), (Matcher)CoreMatchers.is((Object)"application/xml"), (Matcher)CoreMatchers.is((Object)"application/soap+xml")));
        String resp = EntityUtils.toString((HttpEntity)m.getEntity(), (String)"us-ascii");
        Assert.assertThat((Object)resp, (Matcher)CoreMatchers.containsString((String)"<faultstring>&amp;</faultstring>"));
    }

    public void testEntityExpansionDoesNotCauseDenialOfService() throws Exception {
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("SoapXmlParsingTest-soap-billion-laughs.xml");
        SoapXmlParsingTest.assertNotNull((Object)in);
        String contents = IOUtils.toString((InputStream)in, (String)"us-ascii");
        HttpResponse m = this.postToSoapEndpoint(contents);
        String resp = EntityUtils.toString((HttpEntity)m.getEntity(), (String)"us-ascii");
        Assert.assertThat((String)"The response should not indicate a server memory error", (Object)resp, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"java.lang.OutOfMemoryError")));
        MediaType mt = MediaType.valueOf((String)m.getFirstHeader("content-type").getValue());
        Assert.assertThat((String)"The response should be XML, not HTML", (Object)(mt.getType() + '/' + mt.getSubtype()), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.is((Object)"text/xml"), (Matcher)CoreMatchers.is((Object)"application/xml"), (Matcher)CoreMatchers.is((Object)"application/soap+xml")));
    }

    public void testVersionedEndpointsDoNotAllowExpansion() throws Exception {
        String[] versions;
        for (String v : versions = new String[]{"1", "2", "latest"}) {
            this.runEntityExpansionTestWithPathSuffix("/" + v + "/");
        }
    }
}

