/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.demo;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.tests.applications.crowd.LdifLoaderForTesting;
import com.atlassian.crowd.acceptance.tests.applications.demo.DemoAcceptanceTestCase;
import java.io.InputStream;

public class AddGroupTest
extends DemoAcceptanceTestCase {
    private static final String TEST_GROUP_NAME = "test-group";
    private static final String TEST_GROUP_DESCRIPTION = "Test Description";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("viewgrouptest.xml");
        this._loginAdminUser();
    }

    @Override
    protected void tearDown() throws Exception {
        InputStream in = AddGroupTest.class.getResourceAsStream("/com/atlassian/crowd/acceptance/tests/default-entries.ldif");
        AddGroupTest.assertNotNull((Object)in);
        new LdifLoaderForTesting(CrowdAcceptanceTestCase.HOST_PATH).setLdif(in);
        super.tearDown();
    }

    protected void addGroup() {
        this.intendToModifyData();
        this.gotoPage("/secure/group/browsegroups.action");
        this.clickLink("add-group");
        this.setTextField("name", TEST_GROUP_NAME);
        this.setTextField("groupDescription", TEST_GROUP_DESCRIPTION);
        this.checkCheckbox("active");
        this.submit();
    }

    public void testAddGroup() {
        this.intendToModifyData();
        this.log("Running testAddGroup");
        this.addGroup();
        this.assertKeyPresent("menu.viewgroup.label", TEST_GROUP_NAME);
        this.assertTextFieldEquals("groupDescription", TEST_GROUP_DESCRIPTION);
        this.assertCheckboxSelected("active");
    }

    public void testUpdateGroup() {
        this.intendToModifyData();
        this.log("Running testUpdateGroup");
        this.gotoPage("/secure/group/browsegroups.action");
        this.clickLink("view-group-crowd-administrators");
        this.setTextField("groupDescription", TEST_GROUP_DESCRIPTION);
        this.submit();
        this.assertTextFieldEquals("groupDescription", TEST_GROUP_DESCRIPTION);
    }

    public void testRemoveGroup() {
        this.intendToModifyData();
        this.log("Running testRemoveGroup");
        this.addGroup();
        this.assertKeyPresent("menu.viewgroup.label", TEST_GROUP_NAME);
        this.assertTextPresent(TEST_GROUP_NAME);
        this.clickLink("remove-group");
        this.submit();
        this.assertKeyPresent("browser.group.title");
        this.assertTextNotPresent(TEST_GROUP_NAME);
    }
}

