/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowdid.server;

import com.atlassian.crowd.acceptance.tests.BaseUrlFromProperties;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.api.uri.UriBuilderImpl;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.AnyOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openid4java.association.Association;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.discovery.Discovery;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.util.HttpCache;
import org.openid4java.util.HttpResponse;

public class OpenIDServerTestWithOpenID2 {
    private String baseUrl;

    @Before
    public void findBaseUrlForApplication() {
        this.baseUrl = BaseUrlFromProperties.withLocalTestProperties().baseUrlFor("crowdid");
    }

    private String getOpEndpoint() {
        return this.baseUrl + "/op";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOpenId2ResourceHasCorrectMediaType() throws Exception {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.getOpEndpoint()).openConnection();
        try {
            Assert.assertEquals((long)200L, (long)connection.getResponseCode());
            MediaType mt = MediaType.valueOf((String)connection.getContentType());
            Assert.assertEquals((Object)"application/xrds+xml", (Object)(mt.getType() + "/" + mt.getSubtype()));
            Assert.assertThat((String)"There should be no parameters, except for a possible redundant charset declaration", (Object)mt.getParameters(), (Matcher)AnyOf.anyOf((Matcher)CoreMatchers.is(Collections.emptyMap()), (Matcher)CoreMatchers.is((Object)ImmutableMap.of((Object)"charset", (Object)"UTF-8"))));
        }
        finally {
            connection.getInputStream().close();
        }
    }

    @Test
    public void testOpenId2ResourceIsDiscoverable() throws DiscoveryException {
        Discovery discovery = new Discovery();
        List discoveries = discovery.discover(this.getOpEndpoint());
        Assert.assertThat((Object)discoveries, (Matcher)IsCollectionWithSize.hasSize((int)1));
        DiscoveryInformation discovered = (DiscoveryInformation)discoveries.get(0);
        Assert.assertEquals((Object)this.getOpEndpoint(), (Object)discovered.getOPEndpoint().toString());
        Assert.assertNull((Object)discovered.getClaimedIdentifier());
        Assert.assertEquals((Object)"http://specs.openid.net/auth/2.0/server", (Object)discovered.getVersion());
        Assert.assertTrue((boolean)discovered.isVersion2());
    }

    @Test
    public void ableToAssociateWithProvider() throws Exception {
        ConsumerManager manager = new ConsumerManager();
        List discoveries = manager.discover(this.getOpEndpoint());
        DiscoveryInformation discovered = manager.associate(discoveries);
        Assert.assertTrue((boolean)discovered.isVersion2());
        Association assoc = manager.getAssociations().load(this.getOpEndpoint());
        Assert.assertNotNull((Object)assoc);
        Assert.assertThat((Object)(assoc.getExpiry().getTime() - System.currentTimeMillis()), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(TimeUnit.MINUTES.toMillis(10L))));
        Assert.assertEquals((Object)"HMAC-SHA256", (Object)assoc.getType());
    }

    @Test
    public void authenticationRequestProvidesPromptForUserAuthentication() throws Exception {
        ConsumerManager manager = new ConsumerManager();
        manager.associate(manager.discover(this.getOpEndpoint()));
        HttpCache fetcher = new HttpCache();
        ImmutableMap.Builder mb = ImmutableMap.builder();
        mb.put((Object)"openid.ns", (Object)"http://specs.openid.net/auth/2.0");
        mb.put((Object)"openid.mode", (Object)"checkid_setup");
        mb.put((Object)"openid.claimed_id", (Object)this.getOpEndpoint());
        mb.put((Object)"openid.identity", (Object)"http://specs.openid.net/auth/2.0/identifier_select");
        mb.put((Object)"openid.assoc_handle", (Object)manager.getAssociations().load(this.getOpEndpoint()).getHandle());
        mb.put((Object)"openid.return_to", (Object)"http://localhost/return-to");
        HttpResponse resp = fetcher.post(this.getOpEndpoint(), (Map)mb.build());
        Assert.assertEquals((long)302L, (long)resp.getStatusCode());
        Assert.assertEquals((Object)(this.baseUrl + "/secure/interaction/allowauthentication.action"), (Object)resp.getResponseHeader("Location").getValue());
    }

    @Test
    public void authenticationRequestFailsWhenRealmDoesNotMatchReturnToUrl() throws Exception {
        ConsumerManager manager = new ConsumerManager();
        manager.associate(manager.discover(this.getOpEndpoint()));
        HttpCache fetcher = new HttpCache();
        ImmutableMap.Builder mb = ImmutableMap.builder();
        mb.put((Object)"openid.ns", (Object)"http://specs.openid.net/auth/2.0");
        mb.put((Object)"openid.mode", (Object)"checkid_setup");
        mb.put((Object)"openid.claimed_id", (Object)this.getOpEndpoint());
        mb.put((Object)"openid.identity", (Object)"http://specs.openid.net/auth/2.0/identifier_select");
        mb.put((Object)"openid.assoc_handle", (Object)manager.getAssociations().load(this.getOpEndpoint()).getHandle());
        mb.put((Object)"openid.return_to", (Object)"http://example.test/return-to");
        mb.put((Object)"openid.realm", (Object)"http://localhost/");
        HttpResponse resp = fetcher.post(this.getOpEndpoint(), (Map)mb.build());
        Assert.assertEquals((long)400L, (long)resp.getStatusCode());
        Assert.assertThat((Object)resp.getBody(), (Matcher)Matchers.containsString((String)"AuthRequest could not be reconstructed from RequestParameters"));
    }

    @Test
    public void authenticationRequestPassesWhenRealmIsProvidedAndMatchesReturnToUrl() throws Exception {
        ConsumerManager manager = new ConsumerManager();
        manager.associate(manager.discover(this.getOpEndpoint()));
        HttpCache fetcher = new HttpCache();
        ImmutableMap.Builder mb = ImmutableMap.builder();
        mb.put((Object)"openid.ns", (Object)"http://specs.openid.net/auth/2.0");
        mb.put((Object)"openid.mode", (Object)"checkid_setup");
        mb.put((Object)"openid.claimed_id", (Object)this.getOpEndpoint());
        mb.put((Object)"openid.identity", (Object)"http://specs.openid.net/auth/2.0/identifier_select");
        mb.put((Object)"openid.assoc_handle", (Object)manager.getAssociations().load(this.getOpEndpoint()).getHandle());
        mb.put((Object)"openid.return_to", (Object)"http://www.example.test/return-to");
        mb.put((Object)"openid.realm", (Object)"http://*.example.test/");
        HttpResponse resp = fetcher.post(this.getOpEndpoint(), (Map)mb.build());
        Assert.assertEquals((long)302L, (long)resp.getStatusCode());
        Assert.assertEquals((Object)(this.baseUrl + "/secure/interaction/allowauthentication.action"), (Object)resp.getResponseHeader("Location").getValue());
    }

    @Test
    public void authenticationRequestRedirectedAsGetProvidesPromptForUserAuthentication() throws Exception {
        ConsumerManager manager = new ConsumerManager();
        manager.associate(manager.discover(this.getOpEndpoint()));
        ImmutableMap.Builder mb = ImmutableMap.builder();
        mb.put((Object)"openid.ns", (Object)"http://specs.openid.net/auth/2.0");
        mb.put((Object)"openid.mode", (Object)"checkid_setup");
        mb.put((Object)"openid.claimed_id", (Object)this.getOpEndpoint());
        mb.put((Object)"openid.identity", (Object)"http://specs.openid.net/auth/2.0/identifier_select");
        mb.put((Object)"openid.assoc_handle", (Object)manager.getAssociations().load(this.getOpEndpoint()).getHandle());
        mb.put((Object)"openid.return_to", (Object)"http://localhost/return-to");
        UriBuilder builder = UriBuilderImpl.fromUri((String)this.getOpEndpoint());
        for (Map.Entry e : mb.build().entrySet()) {
            builder.queryParam((String)e.getKey(), new Object[]{e.getValue()});
        }
        URL url = builder.build(new Object[0]).toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setInstanceFollowRedirects(false);
        Assert.assertEquals((long)302L, (long)conn.getResponseCode());
        Assert.assertEquals((Object)(this.baseUrl + "/secure/interaction/allowauthentication.action"), (Object)conn.getHeaderField("Location"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void userIdentityPageIsServedAsHtmlByDefault() throws IOException {
        String userIdentifier = this.baseUrl + "/users/admin";
        HttpURLConnection connection = (HttpURLConnection)new URL(userIdentifier).openConnection();
        try {
            Assert.assertEquals((long)200L, (long)connection.getResponseCode());
            MediaType mt = MediaType.valueOf((String)connection.getContentType());
            Assert.assertEquals((Object)"text/html", (Object)(mt.getType() + "/" + mt.getSubtype()));
            Assert.assertThat((String)"There should be no parameters, except for a possible redundant charset declaration", (Object)mt.getParameters(), (Matcher)AnyOf.anyOf((Matcher)CoreMatchers.is(Collections.emptyMap()), (Matcher)CoreMatchers.is((Object)ImmutableMap.of((Object)"charset", (Object)"UTF-8"))));
        }
        finally {
            connection.getInputStream().close();
        }
    }

    @Test
    public void discoveryOfUserIdentifierFindsSignons() throws DiscoveryException {
        Discovery discovery = new Discovery();
        String userIdentifier = this.baseUrl + "/users/admin";
        List discoveries = discovery.discover(userIdentifier);
        Assert.assertThat((Object)discoveries, (Matcher)CoreMatchers.hasItem(OpenIDServerTestWithOpenID2.openIdWithVersionEndpointAndClaimedId("http://openid.net/signon/1.1", this.baseUrl + "/server.openid", userIdentifier)));
        Assert.assertThat((Object)discoveries, (Matcher)CoreMatchers.hasItem(OpenIDServerTestWithOpenID2.openIdWithVersionEndpointAndClaimedId("http://specs.openid.net/auth/2.0/signon", this.getOpEndpoint(), userIdentifier)));
    }

    public static Matcher<DiscoveryInformation> openIdWithVersionEndpointAndClaimedId(final String version, final String endpoint, final String claimedId) {
        return new TypeSafeMatcher<DiscoveryInformation>(DiscoveryInformation.class){

            public void describeTo(Description desc) {
                desc.appendText("A version '" + version + "' identifier with endpoint '" + endpoint + "' and claimed ID '" + claimedId + "'");
            }

            protected boolean matchesSafely(DiscoveryInformation info) {
                return info.getVersion().equals(version) && info.getOPEndpoint().toString().equals(endpoint) && info.getClaimedIdentifier().toString().equals(claimedId);
            }
        };
    }
}

