/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd.user;

import com.atlassian.crowd.acceptance.tests.applications.crowd.user.CrowdUserConsoleAcceptenceTestCase;

public class ChangePasswordTest
extends CrowdUserConsoleAcceptenceTestCase {
    private static final String INTERNAL_DIRECTORY_NAME = "Test Internal Directory";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.loadXmlOnSetUp("userconsoletest.xml");
    }

    @Override
    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testViewChangePasswordWithoutPolicy() {
        this.log("Running testViewChangePasswordWithoutPolicy");
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertKeyNotPresent("principal.password.complexity.policy");
        this.assertWarningAndErrorNotPresent();
        this.assertTextFieldEquals("originalPassword", "");
        this.assertTextFieldEquals("password", "");
        this.assertTextFieldEquals("confirmPassword", "");
    }

    public void testViewChangePasswordWithPolicy() {
        this.log("Running testViewChangePassword");
        this.intendToModifyData();
        this.updateDirectoryWithPasswordRegex("[a-z]", "Passwords <b>must</b> contain at least one lowercase character");
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertKeyPresent("principal.password.complexity.policy");
        this.assertTextPresent("Passwords <b>must</b> contain at least one lowercase character");
        this.assertWarningAndErrorNotPresent();
        this.assertTextFieldEquals("originalPassword", "");
        this.assertTextFieldEquals("password", "");
        this.assertTextFieldEquals("confirmPassword", "");
    }

    public void testChangePasswordOldPasswordBlank() {
        this.log("Running testChangePasswordOldPasswordBlank");
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.submit();
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertKeyPresent("password.invalid");
    }

    public void testChangePasswordNewPasswordBlank() {
        this.log("Running testChangePasswordNewPasswordBlank");
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.setTextField("originalPassword", "password");
        this.submit();
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertKeyPresent("passwordempty.invalid");
    }

    private void updateDirectoryWithPasswordRegex(String passwordRegex, String passwordComplexityMessage) {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(INTERNAL_DIRECTORY_NAME);
        this.clickLink("internal-configuration");
        this.setTextField("passwordRegex", passwordRegex);
        this.setTextField("passwordComplexityMessage", passwordComplexityMessage);
        this.submit();
        this.assertTextFieldEquals("passwordComplexityMessage", passwordComplexityMessage);
    }

    public void testChangePasswordNewPasswordMismatch() {
        this.log("Running testChangePasswordNewPasswordMismatch");
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.setTextField("originalPassword", "password");
        this.setTextField("password", "new");
        this.setTextField("confirmPassword", "somethingelse");
        this.submit();
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertKeyPresent("passworddonotmatch.invalid");
    }

    public void testChangePasswordPasswordDoesNotMeetComplexityRequirements() {
        this.log("Running testChangePasswordPasswordDoesNotMeetComplexityRequirements");
        this.intendToModifyData();
        this._loginAdminUser();
        this.updateDirectoryWithPasswordRegex("[a-z]", "Passwords <b>must</b> contain at least one lowercase character");
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this.assertWarningAndErrorNotPresent();
        this.assertTextPresent("Passwords <b>must</b> contain at least one lowercase character");
        this._changePassword("password", "!@#$1234");
        this.assertErrorPresentWithKey("passwordupdate.policy.error.message");
        this.assertKeyNotPresent("principal.password.complexity.policy");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertTextPresent("Passwords <b>must</b> contain at least one lowercase character");
    }

    public void testChangePasswordOldPasswordWrong() {
        this.log("Running testChangePasswordOldPasswordWrong");
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this._changePassword("wrong", "new");
        this.assertKeyPresent("password.invalid");
    }

    public void testChangePasswordSuccess() {
        this.intendToModifyData();
        this.log("Running testChangePasswordSuccess");
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this._changePassword("password", "new");
        this.assertKeyPresent("resetpassword.complete.label");
        this.assertAtLoginForm();
        this.setTextField("j_username", "user");
        this.setTextField("j_password", "password");
        this.submit();
        this.assertKeyPresent("login.failed.label");
        this.setTextField("j_username", "user");
        this.setTextField("j_password", "new");
        this.submit();
        this.assertIsLoggedIn();
        this.assertKeyPresent("menu.user.console.editprofile.label");
    }

    public void testChangePasswordNewPasswordEqualsCurrentPassword() {
        this.log("Running testChangePasswordNewPasswordEqualsCurrentPassword");
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this._changePassword("password", "password");
        this.assertKeyNotPresent("passwordupdate.message");
        this.assertTextPresent("Unable to update password since this password matches");
    }

    public void testChangePasswordFailsWhenNewPasswordMatchesPasswordHistory() {
        this.intendToModifyData();
        this.log("Running testChangePasswordFailsWhenNewPasswordMatchesPasswordHistory");
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this._changePassword("password", "password1");
        this.assertKeyPresent("resetpassword.complete.label");
        this.assertAtLoginForm();
        this._loginTestUser("user", "password1");
        this.gotoPage("/console/user/viewchangepassword.action");
        this._changePassword("password1", "password2");
        this.assertKeyPresent("resetpassword.complete.label");
        this.assertAtLoginForm();
        this._loginTestUser("user", "password2");
        this.gotoPage("/console/user/viewchangepassword.action");
        this._changePassword("password2", "password3");
        this.assertKeyPresent("resetpassword.complete.label");
        this.assertAtLoginForm();
        this._loginTestUser("user", "password3");
        this.gotoPage("/console/user/viewchangepassword.action");
        this._changePassword("password3", "password2");
        this.assertKeyNotPresent("passwordupdate.message");
        this.assertTextPresent("Unable to update password since this password matches");
        this._changePassword("password3", "password3");
        this.assertKeyNotPresent("passwordupdate.message");
        this.assertTextPresent("Unable to update password since this password matches");
        this._changePassword("password3", "password1");
        this.assertKeyPresent("resetpassword.complete.label");
        this.assertAtLoginForm();
        this._loginTestUser("user", "password1");
        this.gotoPage("/console/user/viewchangepassword.action");
        this._changePassword("password1", "password2");
        this.assertKeyPresent("resetpassword.complete.label");
        this.assertAtLoginForm();
    }

    public void testCredentialHistoryOverflowDoesNotCauseReferentialIntegrityProblems() {
        this.intendToModifyData();
        this.log("Running testCredentialHistoryOverflowDoesNotCauseReferentialIntegrityProblems");
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this._changePassword("password", "password1");
        this.assertKeyPresent("resetpassword.complete.label");
        this.assertAtLoginForm();
        this._loginTestUser("user", "password1");
        this.gotoPage("/console/user/viewchangepassword.action");
        this._changePassword("password1", "password2");
        this.assertKeyPresent("resetpassword.complete.label");
        this.assertAtLoginForm();
        this._loginTestUser("user", "password2");
        this.gotoPage("/console/user/viewchangepassword.action");
        this._changePassword("password2", "password3");
        this.assertKeyPresent("resetpassword.complete.label");
        this.assertAtLoginForm();
        this._loginAdminUser();
        this.gotoViewPrincipal("user", INTERNAL_DIRECTORY_NAME);
        this.clickLink("remove-principal");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
    }

    public void testChangePasswordNoPermissions() {
        this.log("Running testChangePasswordNoPermissions");
        this._loginImmutableUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this._changePassword("password", "new");
        this.assertKeyPresent("user.console.password.permission.error");
    }

    public void testChangePasswordExpiresSessionToken() {
        this.log("Running testChangePasswordExpiresSessionToken");
        this.intendToModifyData();
        this._loginTestUser();
        this.gotoPage("/console/user/viewchangepassword.action");
        this._changePassword("password", "new");
        this.assertIsLoggedOut();
    }

    private void _changePassword(String oldPassword, String newPassword) {
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.setTextField("originalPassword", oldPassword);
        this.setTextField("password", newPassword);
        this.setTextField("confirmPassword", newPassword);
        this.submit();
    }
}

